/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.util.function.Function;
import org.tron.core.vm.repository.Repository;

public enum ChainParameterEnum {
    INVALID_PARAMETER_KEY(0L, ignored -> 0L),
    TOTAL_NET_LIMIT(1L, repository -> repository.getDynamicPropertiesStore().getTotalNetLimit()),
    TOTAL_NET_WEIGHT(2L, Repository::getTotalNetWeight),
    TOTAL_ENERGY_CURRENT_LIMIT(3L, repository -> repository.getDynamicPropertiesStore().getTotalEnergyCurrentLimit()),
    TOTAL_ENERGY_WEIGHT(4L, Repository::getTotalEnergyWeight),
    UNFREEZE_DELAY_DAYS(5L, repository -> repository.getDynamicPropertiesStore().getUnfreezeDelayDays());

    private final long code;
    private final Function<Repository, Long> action;

    private ChainParameterEnum(long code2, Function<Repository, Long> action) {
        this.code = code2;
        this.action = action;
    }

    public static ChainParameterEnum fromCode(long code2) {
        for (ChainParameterEnum each : ChainParameterEnum.values()) {
            if (each.code != code2) continue;
            return each;
        }
        return INVALID_PARAMETER_KEY;
    }

    public long getCode() {
        return this.code;
    }

    public Function<Repository, Long> getAction() {
        return this.action;
    }
}

