/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.WitnessStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.WitnessContract;

public class WitnessCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public WitnessCreateActuator() {
        super(Protocol.Transaction.Contract.ContractType.WitnessCreateContract, WitnessContract.WitnessCreateContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            WitnessContract.WitnessCreateContract witnessCreateContract = (WitnessContract.WitnessCreateContract)this.any.unpack(WitnessContract.WitnessCreateContract.class);
            this.createWitness(witnessCreateContract);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        WitnessContract.WitnessCreateContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        if (!this.any.is(WitnessContract.WitnessCreateContract.class)) {
            throw new ContractValidateException("contract type error, expected type [WitnessCreateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (WitnessContract.WitnessCreateContract)this.any.unpack(WitnessContract.WitnessCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!TransactionUtil.validUrl(contract.getUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        if (witnessStore.has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] has existed");
        }
        if (accountCapsule.getBalance() < dynamicStore.getAccountUpgradeCost()) {
            throw new ContractValidateException("balance < AccountUpgradeCost");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((WitnessContract.WitnessCreateContract)this.any.unpack(WitnessContract.WitnessCreateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getAccountUpgradeCost();
    }

    private void createWitness(WitnessContract.WitnessCreateContract witnessCreateContract) throws BalanceInsufficientException {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        WitnessCapsule witnessCapsule = new WitnessCapsule(witnessCreateContract.getOwnerAddress(), 0L, witnessCreateContract.getUrl().toStringUtf8());
        logger.debug("createWitness,address[{}]", (Object)witnessCapsule.createReadableString());
        witnessStore.put(witnessCapsule.createDbKey(), (ProtoCapsule)witnessCapsule);
        AccountCapsule accountCapsule = accountStore.get(witnessCapsule.createDbKey());
        accountCapsule.setIsWitness(true);
        if (dynamicStore.getAllowMultiSign() == 1L) {
            accountCapsule.setDefaultWitnessPermission(dynamicStore);
        }
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        long cost = dynamicStore.getAccountUpgradeCost();
        Commons.adjustBalance((AccountStore)accountStore, (byte[])witnessCreateContract.getOwnerAddress().toByteArray(), (long)(-cost));
        if (dynamicStore.supportBlackHoleOptimization()) {
            dynamicStore.burnTrx(cost);
        } else {
            Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)cost);
        }
        dynamicStore.addTotalCreateWitnessCost(cost);
    }
}

