/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.math.LongMath;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

public class WithdrawExpireUnfreezeActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public WithdrawExpireUnfreezeActuator() {
        super(Protocol.Transaction.Contract.ContractType.WithdrawExpireUnfreezeContract, BalanceContract.WithdrawExpireUnfreezeContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.WithdrawExpireUnfreezeContract withdrawExpireUnfreezeContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            withdrawExpireUnfreezeContract = (BalanceContract.WithdrawExpireUnfreezeContract)this.any.unpack(BalanceContract.WithdrawExpireUnfreezeContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = accountStore.get(withdrawExpireUnfreezeContract.getOwnerAddress().toByteArray());
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        long totalWithdrawUnfreeze = this.getTotalWithdrawUnfreeze(unfrozenV2List, now);
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(accountCapsule.getBalance() + totalWithdrawUnfreeze).build());
        List<Protocol.Account.UnFreezeV2> newUnFreezeList = this.getRemainWithdrawList(unfrozenV2List, now);
        accountCapsule.clearUnfrozenV2();
        accountCapsule.addAllUnfrozenV2(newUnFreezeList);
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        ret.setWithdrawExpireAmount(totalWithdrawUnfreeze);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        BalanceContract.WithdrawExpireUnfreezeContract withdrawExpireUnfreezeContract;
        if (Objects.isNull(this.any)) {
            throw new ContractValidateException("No contract!");
        }
        if (Objects.isNull(this.chainBaseManager)) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.WithdrawExpireUnfreezeContract.class)) {
            throw new ContractValidateException("contract type error, expected type [WithdrawExpireUnfreezeContract], real type[" + this.any.getClass() + "]");
        }
        if (!dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("Not support WithdrawExpireUnfreeze transaction, need to be opened by the committee");
        }
        try {
            withdrawExpireUnfreezeContract = (BalanceContract.WithdrawExpireUnfreezeContract)this.any.unpack(BalanceContract.WithdrawExpireUnfreezeContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = withdrawExpireUnfreezeContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (Objects.isNull(accountCapsule)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        long totalWithdrawUnfreeze = this.getTotalWithdrawUnfreeze(unfrozenV2List, now);
        if (totalWithdrawUnfreeze <= 0L) {
            throw new ContractValidateException("no unFreeze balance to withdraw ");
        }
        try {
            LongMath.checkedAdd((long)accountCapsule.getBalance(), (long)totalWithdrawUnfreeze);
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    private long getTotalWithdrawUnfreeze(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return this.getTotalWithdrawList(unfrozenV2List, now).stream().mapToLong(Protocol.Account.UnFreezeV2::getUnfreezeAmount).sum();
    }

    private List<Protocol.Account.UnFreezeV2> getTotalWithdrawList(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeAmount() > 0L && unfrozenV2.getUnfreezeExpireTime() <= now).collect(Collectors.toList());
    }

    private List<Protocol.Account.UnFreezeV2> getRemainWithdrawList(List<Protocol.Account.UnFreezeV2> unfrozenV2List, long now) {
        return unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeExpireTime() > now).collect(Collectors.toList());
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.WithdrawExpireUnfreezeContract)this.any.unpack(BalanceContract.WithdrawExpireUnfreezeContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

