/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.zksnark.IncrementalMerkleTreeContainer;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.common.zksnark.MerkleContainer;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ZkProofValidateException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.NullifierStore;
import org.tron.core.store.ZKProofStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ShieldContract;

public class ShieldedTransferActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private ShieldContract.ShieldedTransferContract shieldedTransferContract;

    public ShieldedTransferActuator() {
        super(Protocol.Transaction.Contract.ContractType.ShieldedTransferContract, ShieldContract.ShieldedTransferContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            this.shieldedTransferContract = (ShieldContract.ShieldedTransferContract)this.any.unpack(ShieldContract.ShieldedTransferContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractExeException(e.getMessage());
        }
        long fee = this.calcFee(this.shieldedTransferContract);
        try {
            if (this.shieldedTransferContract.getTransparentFromAddress().toByteArray().length > 0) {
                this.executeTransparentFrom(this.shieldedTransferContract.getTransparentFromAddress().toByteArray(), this.shieldedTransferContract.getFromAmount(), ret, fee);
            }
            Commons.adjustAssetBalanceV2((AccountCapsule)accountStore.getBlackhole(), (String)CommonParameter.getInstance().getZenTokenId(), (long)fee, (AccountStore)accountStore, (AssetIssueStore)assetIssueStore, (DynamicPropertiesStore)dynamicStore);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            ret.setShieldedTransactionFee(fee);
            throw new ContractExeException(e.getMessage());
        }
        this.executeShielded(this.shieldedTransferContract.getSpendDescriptionList(), this.shieldedTransferContract.getReceiveDescriptionList(), ret, fee);
        if (this.shieldedTransferContract.getTransparentToAddress().toByteArray().length > 0) {
            this.executeTransparentTo(this.shieldedTransferContract.getTransparentToAddress().toByteArray(), this.shieldedTransferContract.getToAmount(), ret, fee);
        }
        try {
            Commons.adjustTotalShieldedPoolValue((long)Math.addExact(Math.subtractExact(this.shieldedTransferContract.getToAmount(), this.shieldedTransferContract.getFromAmount()), fee), (DynamicPropertiesStore)dynamicStore);
        }
        catch (ArithmeticException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            ret.setShieldedTransactionFee(fee);
            throw new ContractExeException(e.getMessage());
        }
        ret.setStatus(0L, Protocol.Transaction.Result.code.SUCESS);
        ret.setShieldedTransactionFee(fee);
        return true;
    }

    private void executeTransparentFrom(byte[] ownerAddress, long amount, TransactionResultCapsule ret, long fee) throws ContractExeException {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            Commons.adjustAssetBalanceV2((byte[])ownerAddress, (String)CommonParameter.getInstance().getZenTokenId(), (long)(-amount), (AccountStore)accountStore, (AssetIssueStore)assetIssueStore, (DynamicPropertiesStore)dynamicStore);
        }
        catch (BalanceInsufficientException e) {
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            ret.setShieldedTransactionFee(fee);
            throw new ContractExeException(e.getMessage());
        }
    }

    private void executeTransparentTo(byte[] toAddress, long amount, TransactionResultCapsule ret, long fee) throws ContractExeException {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            AccountCapsule toAccount = accountStore.get(toAddress);
            if (toAccount == null) {
                boolean withDefaultPermission = dynamicStore.getAllowMultiSign() == 1L;
                toAccount = new AccountCapsule(ByteString.copyFrom((byte[])toAddress), Protocol.AccountType.Normal, dynamicStore.getLatestBlockHeaderTimestamp(), withDefaultPermission, dynamicStore);
                accountStore.put(toAddress, toAccount);
            }
            Commons.adjustAssetBalanceV2((byte[])toAddress, (String)CommonParameter.getInstance().getZenTokenId(), (long)amount, (AccountStore)accountStore, (AssetIssueStore)assetIssueStore, (DynamicPropertiesStore)dynamicStore);
        }
        catch (BalanceInsufficientException e) {
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            ret.setShieldedTransactionFee(fee);
            throw new ContractExeException(e.getMessage());
        }
    }

    private void executeShielded(List<ShieldContract.SpendDescription> spends, List<ShieldContract.ReceiveDescription> receives, TransactionResultCapsule ret, long fee) throws ContractExeException {
        NullifierStore nullifierStore = this.chainBaseManager.getNullifierStore();
        MerkleContainer merkleContainer = this.chainBaseManager.getMerkleContainer();
        for (ShieldContract.SpendDescription spend : spends) {
            if (nullifierStore.has(new BytesCapsule(spend.getNullifier().toByteArray()).getData())) {
                ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
                ret.setShieldedTransactionFee(fee);
                throw new ContractExeException("double spend");
            }
            nullifierStore.put(new BytesCapsule(spend.getNullifier().toByteArray()));
        }
        if (CommonParameter.getInstance().isFullNodeAllowShieldedTransactionArgs()) {
            IncrementalMerkleTreeContainer currentMerkle = merkleContainer.getCurrentMerkle();
            try {
                currentMerkle.wfcheck();
            }
            catch (ZksnarkException e) {
                ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
                ret.setShieldedTransactionFee(fee);
                throw new ContractExeException(e.getMessage());
            }
            for (ShieldContract.ReceiveDescription receive : receives) {
                try {
                    merkleContainer.saveCmIntoMerkleTree(currentMerkle, receive.getNoteCommitment().toByteArray());
                }
                catch (ZksnarkException e) {
                    ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
                    ret.setShieldedTransactionFee(fee);
                    throw new ContractExeException(e.getMessage());
                }
            }
            merkleContainer.setCurrentMerkle(currentMerkle);
        }
    }

    public boolean validate() throws ContractValidateException {
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        NullifierStore nullifierStore = this.chainBaseManager.getNullifierStore();
        MerkleContainer merkleContainer = this.chainBaseManager.getMerkleContainer();
        try {
            this.shieldedTransferContract = (ShieldContract.ShieldedTransferContract)this.any.unpack(ShieldContract.ShieldedTransferContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (dynamicStore.getAllowSameTokenName() != 1L) {
            throw new ContractValidateException("shielded transaction is not allowed before ALLOW_SAME_TOKEN_NAME is opened by the committee");
        }
        if (!dynamicStore.supportShieldedTransaction()) {
            throw new ContractValidateException("Not support Shielded Transaction, need to be opened by the committee");
        }
        long fee = this.calcFee(this.shieldedTransferContract);
        this.checkSender(this.shieldedTransferContract);
        this.checkReceiver(this.shieldedTransferContract);
        this.validateTransparent(this.shieldedTransferContract, fee);
        List spendDescriptions = this.shieldedTransferContract.getSpendDescriptionList();
        if (CollectionUtils.isNotEmpty((Collection)spendDescriptions)) {
            HashSet<ByteString> nfSet = new HashSet<ByteString>();
            for (ShieldContract.SpendDescription spendDescription : spendDescriptions) {
                if (nfSet.contains(spendDescription.getNullifier())) {
                    throw new ContractValidateException("duplicate sapling nullifiers in this transaction");
                }
                nfSet.add(spendDescription.getNullifier());
                if (CommonParameter.getInstance().isFullNodeAllowShieldedTransactionArgs() && !merkleContainer.merkleRootExist(spendDescription.getAnchor().toByteArray())) {
                    throw new ContractValidateException("Rt is invalid.");
                }
                if (!nullifierStore.has(spendDescription.getNullifier().toByteArray())) continue;
                throw new ContractValidateException("note has been spend in this transaction");
            }
        }
        List receiveDescriptions = this.shieldedTransferContract.getReceiveDescriptionList();
        HashSet<ByteString> receiveSet = new HashSet<ByteString>();
        for (ShieldContract.ReceiveDescription receiveDescription : receiveDescriptions) {
            if (receiveSet.contains(receiveDescription.getNoteCommitment())) {
                throw new ContractValidateException("duplicate cm in receive_description");
            }
            receiveSet.add(receiveDescription.getNoteCommitment());
        }
        if (CollectionUtils.isEmpty((Collection)spendDescriptions) && CollectionUtils.isEmpty((Collection)receiveDescriptions)) {
            throw new ContractValidateException("no Description found in transaction");
        }
        try {
            this.checkProof(spendDescriptions, receiveDescriptions, fee);
        }
        catch (ZkProofValidateException e) {
            if (e.isFirstValidated()) {
                this.recordProof(this.tx.getTransactionId(), false);
            }
            throw e;
        }
        return true;
    }

    private void checkProof(List<ShieldContract.SpendDescription> spendDescriptions, List<ShieldContract.ReceiveDescription> receiveDescriptions, long fee) throws ZkProofValidateException {
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        ZKProofStore proofStore = this.chainBaseManager.getProofStore();
        if (proofStore.has(this.tx.getTransactionId().getBytes())) {
            if (proofStore.get(this.tx.getTransactionId().getBytes()).booleanValue()) {
                return;
            }
            throw new ZkProofValidateException("record is fail, skip proof", false);
        }
        byte[] signHash = TransactionCapsule.getShieldTransactionHashIgnoreTypeException((Protocol.Transaction)this.tx.getInstance());
        if (CollectionUtils.isNotEmpty(spendDescriptions) || CollectionUtils.isNotEmpty(receiveDescriptions)) {
            long ctx = JLibrustzcash.librustzcashSaplingVerificationCtxInit();
            try {
                long valueBalance;
                for (ShieldContract.SpendDescription spendDescription : spendDescriptions) {
                    if (JLibrustzcash.librustzcashSaplingCheckSpend((LibrustzcashParam.CheckSpendParams)new LibrustzcashParam.CheckSpendParams(ctx, spendDescription.getValueCommitment().toByteArray(), spendDescription.getAnchor().toByteArray(), spendDescription.getNullifier().toByteArray(), spendDescription.getRk().toByteArray(), spendDescription.getZkproof().toByteArray(), spendDescription.getSpendAuthoritySignature().toByteArray(), signHash))) continue;
                    throw new ZkProofValidateException("librustzcashSaplingCheckSpend error", true);
                }
                for (ShieldContract.ReceiveDescription receiveDescription : receiveDescriptions) {
                    if (receiveDescription.getCEnc().size() != 580 || receiveDescription.getCOut().size() != 80) {
                        throw new ZkProofValidateException("Cout or CEnc size error", true);
                    }
                    if (JLibrustzcash.librustzcashSaplingCheckOutput((LibrustzcashParam.CheckOutputParams)new LibrustzcashParam.CheckOutputParams(ctx, receiveDescription.getValueCommitment().toByteArray(), receiveDescription.getNoteCommitment().toByteArray(), receiveDescription.getEpk().toByteArray(), receiveDescription.getZkproof().toByteArray()))) continue;
                    throw new ZkProofValidateException("librustzcashSaplingCheckOutput error", true);
                }
                long totalShieldedPoolValue = dynamicStore.getTotalShieldedPoolValue();
                try {
                    valueBalance = Math.addExact(Math.subtractExact(this.shieldedTransferContract.getToAmount(), this.shieldedTransferContract.getFromAmount()), fee);
                    totalShieldedPoolValue = Math.subtractExact(totalShieldedPoolValue, valueBalance);
                }
                catch (ArithmeticException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ZkProofValidateException(e.getMessage(), true);
                }
                if (totalShieldedPoolValue < 0L) {
                    throw new ZkProofValidateException("shieldedPoolValue error", true);
                }
                if (!JLibrustzcash.librustzcashSaplingFinalCheck((LibrustzcashParam.FinalCheckParams)new LibrustzcashParam.FinalCheckParams(ctx, valueBalance, this.shieldedTransferContract.getBindingSignature().toByteArray(), signHash))) {
                    throw new ZkProofValidateException("librustzcashSaplingFinalCheck error", true);
                }
            }
            catch (ZksnarkException e) {
                throw new ZkProofValidateException(e.getMessage(), true);
            }
            finally {
                JLibrustzcash.librustzcashSaplingVerificationCtxFree((long)ctx);
            }
        }
        this.recordProof(this.tx.getTransactionId(), true);
    }

    private void recordProof(Sha256Hash tid, boolean result) {
        ZKProofStore proofStore = this.chainBaseManager.getProofStore();
        proofStore.put(tid.getBytes(), Boolean.valueOf(result));
    }

    private void checkSender(ShieldContract.ShieldedTransferContract shieldedTransferContract) throws ContractValidateException {
        if (!shieldedTransferContract.getTransparentFromAddress().isEmpty() && shieldedTransferContract.getSpendDescriptionCount() > 0) {
            throw new ContractValidateException("ShieldedTransferContract error, more than 1 senders");
        }
        if (shieldedTransferContract.getTransparentFromAddress().isEmpty() && shieldedTransferContract.getSpendDescriptionCount() == 0) {
            throw new ContractValidateException("ShieldedTransferContract error, no sender");
        }
        if (shieldedTransferContract.getSpendDescriptionCount() > 1) {
            throw new ContractValidateException("ShieldedTransferContract error, number of spend notes should not be more than 1");
        }
    }

    private void checkReceiver(ShieldContract.ShieldedTransferContract shieldedTransferContract) throws ContractValidateException {
        if (shieldedTransferContract.getReceiveDescriptionCount() == 0) {
            throw new ContractValidateException("ShieldedTransferContract error, no output cm");
        }
        if (shieldedTransferContract.getReceiveDescriptionCount() > 2) {
            throw new ContractValidateException("ShieldedTransferContract error, number of receivers should not be more than 2");
        }
    }

    private void validateTransparent(ShieldContract.ShieldedTransferContract shieldedTransferContract, long fee) throws ContractValidateException {
        byte[] toAddress = shieldedTransferContract.getTransparentToAddress().toByteArray();
        byte[] ownerAddress = shieldedTransferContract.getTransparentFromAddress().toByteArray();
        boolean hasTransparentFrom = ownerAddress.length > 0;
        boolean hasTransparentTo = toAddress.length > 0;
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        long fromAmount = shieldedTransferContract.getFromAmount();
        long toAmount = shieldedTransferContract.getToAmount();
        if (fromAmount < 0L) {
            throw new ContractValidateException("from_amount should not be less than 0");
        }
        if (toAmount < 0L) {
            throw new ContractValidateException("to_amount should not be less than 0");
        }
        if (hasTransparentFrom && !DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid transparent_from_address");
        }
        if (!hasTransparentFrom && fromAmount != 0L) {
            throw new ContractValidateException("no transparent_from_address, from_amount should be 0");
        }
        if (hasTransparentTo && !DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid transparent_to_address");
        }
        if (!hasTransparentTo && toAmount != 0L) {
            throw new ContractValidateException("no transparent_to_address, to_amount should be 0");
        }
        if (hasTransparentFrom && hasTransparentTo && Arrays.equals(toAddress, ownerAddress)) {
            throw new ContractValidateException("Can't transfer zen to yourself");
        }
        if (hasTransparentFrom) {
            AccountCapsule ownerAccount = accountStore.get(ownerAddress);
            if (ownerAccount == null) {
                throw new ContractValidateException("Validate ShieldedTransferContract error, no OwnerAccount");
            }
            long balance = this.getZenBalance(ownerAccount);
            if (fromAmount <= 0L) {
                throw new ContractValidateException("from_amount must be greater than 0");
            }
            if (balance < fromAmount) {
                throw new ContractValidateException("Validate ShieldedTransferContract error, balance is not sufficient");
            }
            if (fromAmount <= fee) {
                throw new ContractValidateException("Validate ShieldedTransferContract error, fromAmount should be great than fee");
            }
        }
        if (hasTransparentTo) {
            if (toAmount <= 0L) {
                throw new ContractValidateException("to_amount must be greater than 0");
            }
            AccountCapsule toAccount = accountStore.get(toAddress);
            if (toAccount != null) {
                try {
                    Math.addExact(this.getZenBalance(toAccount), toAmount);
                }
                catch (ArithmeticException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
            }
        }
    }

    private long getZenBalance(AccountCapsule account) {
        return account.getAssetV2(CommonParameter.getInstance().getZenTokenId());
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        ByteString owner = ((ShieldContract.ShieldedTransferContract)this.any.unpack(ShieldContract.ShieldedTransferContract.class)).getTransparentFromAddress();
        if (DecodeUtil.addressValid((byte[])owner.toByteArray())) {
            return owner;
        }
        return null;
    }

    private long calcFee(ShieldContract.ShieldedTransferContract shieldedTransferContract) {
        AccountCapsule toAccount;
        boolean hasTransparentTo;
        byte[] toAddress = shieldedTransferContract.getTransparentToAddress().toByteArray();
        boolean bl = hasTransparentTo = toAddress.length > 0;
        if (hasTransparentTo && (toAccount = this.chainBaseManager.getAccountStore().get(toAddress)) == null) {
            return this.chainBaseManager.getDynamicPropertiesStore().getShieldedTransactionCreateAccountFee();
        }
        return this.chainBaseManager.getDynamicPropertiesStore().getShieldedTransactionFee();
    }

    public long calcFee() {
        return 0L;
    }
}

