/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IFileSystemService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

class RemoteFileChannel
extends FileChannel {
    private static final int PIPE_CAPACITY = 65536;
    private final IFileSystemService fs;
    private final int mode;
    private final Object fdLock = new Object();
    private final FileDescriptor read;
    private final FileDescriptor write;
    private final int handle;

    RemoteFileChannel(IFileSystemService fs, File file, int mode) throws IOException {
        this.fs = fs;
        this.mode = mode;
        File fifo = null;
        try {
            fifo = FileUtils.createTempFIFO();
            int posixMode = FileUtils.modeToPosix(mode);
            this.handle = (Integer)fs.openChannel(file.getAbsolutePath(), posixMode, fifo.getPath()).tryAndGet();
            this.read = Os.open((String)fifo.getPath(), (int)(OsConstants.O_RDONLY | OsConstants.O_NONBLOCK), (int)0);
            this.write = Os.open((String)fifo.getPath(), (int)(OsConstants.O_WRONLY | OsConstants.O_NONBLOCK), (int)0);
        }
        catch (RemoteException | ErrnoException e) {
            throw new IOException(e);
        }
        finally {
            if (fifo != null) {
                fifo.delete();
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private boolean writable() {
        switch (this.mode & 0x30000000) {
            case 0x20000000: 
            case 0x30000000: {
                return true;
            }
        }
        return false;
    }

    private boolean readable() {
        switch (this.mode & 0x30000000) {
            case 0x10000000: 
            case 0x30000000: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0(ByteBuffer dst, long offset) throws IOException {
        this.begin();
        int limit = dst.limit();
        int initial = dst.position();
        boolean success = false;
        try {
            int pos = initial;
            while (limit > pos) {
                int len;
                Object object = this.fdLock;
                synchronized (object) {
                    block14: {
                        if (this.isOpen() && !Thread.interrupted()) break block14;
                        int n = -1;
                        return n;
                    }
                    len = (Integer)this.fs.pread(this.handle, limit - pos, offset).tryAndGet();
                    if (len == 0) {
                        break;
                    }
                    dst.limit(pos + len);
                    for (int sz = 0; sz < len; sz += Os.read((FileDescriptor)this.read, (ByteBuffer)dst)) {
                    }
                }
                if (offset >= 0L) {
                    offset += (long)len;
                }
                pos = dst.position();
            }
            success = true;
            int n = pos - initial;
            return n;
        }
        catch (RemoteException | ErrnoException e) {
            throw new IOException(e);
        }
        finally {
            dst.limit(limit);
            this.end(success);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (!this.readable()) {
            throw new NonReadableChannelException();
        }
        return this.read0(dst, -1L);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.readable()) {
            throw new NonReadableChannelException();
        }
        int sz = 0;
        for (int i = offset; i < offset + length; ++i) {
            sz += this.read0(dsts[i], -1L);
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write0(ByteBuffer src, long offset) throws IOException {
        this.begin();
        int remaining = src.remaining();
        boolean success = false;
        try {
            int len;
            while (src.hasRemaining()) {
                Object object = this.fdLock;
                synchronized (object) {
                    block11: {
                        if (this.isOpen() && !Thread.interrupted()) break block11;
                        int n = -1;
                        return n;
                    }
                    len = Os.write((FileDescriptor)this.write, (ByteBuffer)src);
                    this.fs.pwrite(this.handle, len, offset).checkException();
                }
                if (offset < 0L) continue;
                offset += (long)len;
            }
            success = true;
            len = remaining;
            return len;
        }
        catch (RemoteException | ErrnoException e) {
            throw new IOException(e);
        }
        finally {
            this.end(success);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        if (!this.writable()) {
            throw new NonWritableChannelException();
        }
        return this.write0(src, -1L);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.writable()) {
            throw new NonWritableChannelException();
        }
        int sz = 0;
        for (int i = offset; i < offset + length; ++i) {
            sz += this.write(srcs[i]);
        }
        return sz;
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen();
        try {
            return (Long)this.fs.lseek(this.handle, 0L, OsConstants.SEEK_CUR).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RemoteFileChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            this.fs.lseek(this.handle, newPosition, OsConstants.SEEK_SET).checkException();
            return this;
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen();
        try {
            return (Long)this.fs.size(this.handle).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RemoteFileChannel truncate(long size) throws IOException {
        this.ensureOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writable()) {
            throw new NonWritableChannelException();
        }
        try {
            this.fs.ftruncate(this.handle, size).checkException();
            return this;
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.ensureOpen();
        try {
            this.fs.sync(this.handle, metaData).checkException();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long bytes;
        int len;
        this.ensureOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable()) {
            throw new NonReadableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        ByteBuffer b = ByteBuffer.allocateDirect(65536);
        for (bytes = 0L; count > bytes; bytes += (long)len) {
            int limit = (int)Math.min((long)b.capacity(), count - bytes);
            b.limit(limit);
            if (this.read0(b, position) <= 0) break;
            b.flip();
            len = target.write(b);
            position += (long)len;
            b.clear();
        }
        return bytes;
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        long bytes;
        int len;
        this.ensureOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable()) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        ByteBuffer b = ByteBuffer.allocateDirect(65536);
        for (bytes = 0L; count > bytes; bytes += (long)len) {
            int limit = (int)Math.min((long)b.capacity(), count - bytes);
            b.limit(limit);
            if (src.read(b) <= 0) break;
            b.flip();
            len = this.write0(b, position);
            position += (long)len;
            b.clear();
        }
        return bytes;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        this.ensureOpen();
        return this.read0(dst, position);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        this.ensureOpen();
        return this.write0(src, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() {
        try {
            this.fs.close(this.handle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.fdLock;
        synchronized (object) {
            try {
                Os.close((FileDescriptor)this.read);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            try {
                Os.close((FileDescriptor)this.write);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        throw new UnsupportedOperationException("Memory mapping a remote file is not supported!");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException("Locking a remote file is not supported!");
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException("Locking a remote file is not supported!");
    }
}

