/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.os.Build;
import android.system.ErrnoException;
import android.system.Int64Ref;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArraySet;
import android.util.MutableLong;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;

@SuppressLint(value={"DiscouragedPrivateApi"})
class FileUtils {
    private static Object os;
    private static Method splice;
    private static Method sendfile;
    private static AccessibleObject setFd;

    FileUtils() {
    }

    static int modeToPosix(int mode) {
        int res;
        if ((mode & 0x30000000) == 0x30000000) {
            res = OsConstants.O_RDWR;
        } else if ((mode & 0x20000000) == 0x20000000) {
            res = OsConstants.O_WRONLY;
        } else if ((mode & 0x10000000) == 0x10000000) {
            res = OsConstants.O_RDONLY;
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 0x8000000) == 0x8000000) {
            res |= OsConstants.O_CREAT;
        }
        if ((mode & 0x4000000) == 0x4000000) {
            res |= OsConstants.O_TRUNC;
        }
        if ((mode & 0x2000000) == 0x2000000) {
            res |= OsConstants.O_APPEND;
        }
        return res;
    }

    @RequiresApi(api=26)
    static Set<OpenOption> modeToOptions(int mode) {
        ArraySet set = new ArraySet();
        if ((mode & 0x30000000) == 0x30000000) {
            set.add(StandardOpenOption.READ);
            set.add(StandardOpenOption.WRITE);
        } else if ((mode & 0x20000000) == 0x20000000) {
            set.add(StandardOpenOption.WRITE);
        } else if ((mode & 0x10000000) == 0x10000000) {
            set.add(StandardOpenOption.READ);
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 0x8000000) == 0x8000000) {
            set.add(StandardOpenOption.CREATE);
        }
        if ((mode & 0x4000000) == 0x4000000) {
            set.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((mode & 0x2000000) == 0x2000000) {
            set.add(StandardOpenOption.APPEND);
        }
        return set;
    }

    static Flag modeToFlag(int mode) {
        Flag f = new Flag();
        if ((mode & 0x30000000) == 0x30000000) {
            f.read = true;
            f.write = true;
        } else if ((mode & 0x20000000) == 0x20000000) {
            f.write = true;
        } else if ((mode & 0x10000000) == 0x10000000) {
            f.read = true;
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 0x8000000) == 0x8000000) {
            f.create = true;
        }
        if ((mode & 0x4000000) == 0x4000000) {
            f.truncate = true;
        }
        if ((mode & 0x2000000) == 0x2000000) {
            f.append = true;
        }
        if (f.append && f.read) {
            throw new IllegalArgumentException("READ + APPEND not allowed");
        }
        if (f.append && f.truncate) {
            throw new IllegalArgumentException("APPEND + TRUNCATE not allowed");
        }
        return f;
    }

    @RequiresApi(api=28)
    static long splice(FileDescriptor fdIn, Int64Ref offIn, FileDescriptor fdOut, Int64Ref offOut, long len, int flags) throws ErrnoException {
        try {
            if (splice == null) {
                splice = Os.class.getMethod("splice", FileDescriptor.class, Int64Ref.class, FileDescriptor.class, Int64Ref.class, Long.TYPE, Integer.TYPE);
            }
            return (Long)splice.invoke(null, fdIn, offIn, fdOut, offOut, len, flags);
        }
        catch (InvocationTargetException e) {
            throw (ErrnoException)e.getTargetException();
        }
        catch (ReflectiveOperationException e) {
            throw new ErrnoException("splice", OsConstants.ENOSYS);
        }
    }

    static long sendfile(FileDescriptor outFd, FileDescriptor inFd, MutableLong inOffset, long byteCount) throws ErrnoException {
        if (Build.VERSION.SDK_INT >= 28) {
            Int64Ref off = inOffset == null ? null : new Int64Ref(inOffset.value);
            long result = Os.sendfile((FileDescriptor)outFd, (FileDescriptor)inFd, (Int64Ref)off, (long)byteCount);
            if (off != null) {
                inOffset.value = off.value;
            }
            return result;
        }
        try {
            if (os == null) {
                os = Class.forName("libcore.io.Libcore").getField("os").get(null);
            }
            if (sendfile == null) {
                sendfile = os.getClass().getMethod("sendfile", FileDescriptor.class, FileDescriptor.class, MutableLong.class, Long.TYPE);
            }
            return (Long)sendfile.invoke(os, outFd, inFd, inOffset, byteCount);
        }
        catch (InvocationTargetException e) {
            throw (ErrnoException)e.getTargetException();
        }
        catch (ReflectiveOperationException e) {
            throw new ErrnoException("sendfile", OsConstants.ENOSYS);
        }
    }

    static File createTempFIFO() throws ErrnoException, IOException {
        File fifo = File.createTempFile("libsu-fifo-", null);
        fifo.delete();
        Os.mkfifo((String)fifo.getPath(), (int)420);
        return fifo;
    }

    static FileDescriptor createFileDescriptor(int fd) {
        if (setFd == null) {
            try {
                setFd = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                try {
                    setFd = FileDescriptor.class.getDeclaredMethod("setInt$", Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            setFd.setAccessible(true);
        }
        try {
            if (setFd instanceof Constructor) {
                return (FileDescriptor)((Constructor)setFd).newInstance(fd);
            }
            FileDescriptor f = new FileDescriptor();
            ((Method)setFd).invoke((Object)f, fd);
            return f;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    static class Flag {
        boolean read;
        boolean write;
        boolean create;
        boolean truncate;
        boolean append;

        Flag() {
        }
    }
}

