/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.LruCache;
import com.topjohnwu.superuser.internal.FileContainer;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IFileSystemService;
import com.topjohnwu.superuser.internal.IOResult;
import com.topjohnwu.superuser.internal.OpenFile;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class FileSystemService
extends IFileSystemService.Stub {
    static final int PIPE_CAPACITY = 65536;
    private final LruCache<String, File> mCache = new LruCache<String, File>(100){

        protected File create(String key) {
            return new File(key);
        }
    };
    private final FileContainer openFiles = new FileContainer();
    private final ExecutorService streamPool = Executors.newCachedThreadPool();

    FileSystemService() {
    }

    @Override
    public IOResult getCanonicalPath(String path) {
        try {
            return new IOResult(((File)this.mCache.get((Object)path)).getCanonicalPath());
        }
        catch (IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public boolean isDirectory(String path) {
        return ((File)this.mCache.get((Object)path)).isDirectory();
    }

    @Override
    public boolean isFile(String path) {
        return ((File)this.mCache.get((Object)path)).isFile();
    }

    @Override
    public boolean isHidden(String path) {
        return ((File)this.mCache.get((Object)path)).isHidden();
    }

    @Override
    public long lastModified(String path) {
        return ((File)this.mCache.get((Object)path)).lastModified();
    }

    @Override
    public long length(String path) {
        return ((File)this.mCache.get((Object)path)).length();
    }

    @Override
    public IOResult createNewFile(String path) {
        try {
            return new IOResult(((File)this.mCache.get((Object)path)).createNewFile());
        }
        catch (IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public boolean delete(String path) {
        return ((File)this.mCache.get((Object)path)).delete();
    }

    @Override
    public String[] list(String path) {
        return ((File)this.mCache.get((Object)path)).list();
    }

    @Override
    public boolean mkdir(String path) {
        return ((File)this.mCache.get((Object)path)).mkdir();
    }

    @Override
    public boolean mkdirs(String path) {
        return ((File)this.mCache.get((Object)path)).mkdirs();
    }

    @Override
    public boolean renameTo(String path, String dest) {
        return ((File)this.mCache.get((Object)path)).renameTo((File)this.mCache.get((Object)dest));
    }

    @Override
    public boolean setLastModified(String path, long time) {
        return ((File)this.mCache.get((Object)path)).setLastModified(time);
    }

    @Override
    public boolean setReadOnly(String path) {
        return ((File)this.mCache.get((Object)path)).setReadOnly();
    }

    @Override
    public boolean setWritable(String path, boolean writable, boolean ownerOnly) {
        return ((File)this.mCache.get((Object)path)).setWritable(writable, ownerOnly);
    }

    @Override
    public boolean setReadable(String path, boolean readable, boolean ownerOnly) {
        return ((File)this.mCache.get((Object)path)).setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setExecutable(String path, boolean executable, boolean ownerOnly) {
        return ((File)this.mCache.get((Object)path)).setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean checkAccess(String path, int access) {
        try {
            return Os.access((String)path, (int)access);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    public long getTotalSpace(String path) {
        return ((File)this.mCache.get((Object)path)).getTotalSpace();
    }

    @Override
    public long getFreeSpace(String path) {
        return ((File)this.mCache.get((Object)path)).getFreeSpace();
    }

    @Override
    @SuppressLint(value={"UsableSpace"})
    public long getUsableSpace(String path) {
        return ((File)this.mCache.get((Object)path)).getUsableSpace();
    }

    @Override
    public int getMode(String path) {
        try {
            return Os.lstat((String)path).st_mode;
        }
        catch (ErrnoException e) {
            return 0;
        }
    }

    @Override
    public IOResult createLink(String link, String target, boolean soft) {
        try {
            if (soft) {
                Os.symlink((String)target, (String)link);
            } else {
                Os.link((String)target, (String)link);
            }
            return new IOResult(true);
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.EEXIST) {
                return new IOResult(false);
            }
            return new IOResult((Object)e);
        }
    }

    @Override
    public void register(IBinder client) {
        int pid = Binder.getCallingPid();
        try {
            client.linkToDeath(() -> this.openFiles.pidDied(pid), 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public IOResult openChannel(String path, int mode, String fifo) {
        OpenFile f = new OpenFile();
        try {
            f.fd = Os.open((String)path, (int)(mode | OsConstants.O_NONBLOCK), (int)438);
            f.read = Os.open((String)fifo, (int)(OsConstants.O_RDONLY | OsConstants.O_NONBLOCK), (int)0);
            f.write = Os.open((String)fifo, (int)(OsConstants.O_WRONLY | OsConstants.O_NONBLOCK), (int)0);
            return new IOResult(this.openFiles.put(f));
        }
        catch (ErrnoException e) {
            f.close();
            return new IOResult((Object)e);
        }
    }

    @Override
    public IOResult openReadStream(String path, ParcelFileDescriptor fd) {
        OpenFile f = new OpenFile();
        try {
            f.fd = Os.open((String)path, (int)OsConstants.O_RDONLY, (int)0);
            this.streamPool.execute(() -> {
                try (OpenFile of = f;){
                    of.write = FileUtils.createFileDescriptor(fd.detachFd());
                    while (of.pread(65536, -1L) > 0) {
                    }
                }
                catch (ErrnoException | IOException throwable) {
                    // empty catch block
                }
            });
            return new IOResult();
        }
        catch (ErrnoException e) {
            f.close();
            return new IOResult((Object)e);
        }
    }

    @Override
    public IOResult openWriteStream(String path, ParcelFileDescriptor fd, boolean append) {
        OpenFile f = new OpenFile();
        try {
            int mode = OsConstants.O_CREAT | OsConstants.O_WRONLY | (append ? OsConstants.O_APPEND : OsConstants.O_TRUNC);
            f.fd = Os.open((String)path, (int)mode, (int)438);
            this.streamPool.execute(() -> {
                try (OpenFile of = f;){
                    of.read = FileUtils.createFileDescriptor(fd.detachFd());
                    while (of.pwrite(65536, -1L, false) > 0) {
                    }
                }
                catch (ErrnoException | IOException throwable) {
                    // empty catch block
                }
            });
            return new IOResult();
        }
        catch (ErrnoException e) {
            f.close();
            return new IOResult((Object)e);
        }
    }

    @Override
    public void close(int handle) {
        this.openFiles.remove(handle);
    }

    @Override
    public IOResult pread(int handle, int len, long offset) {
        try {
            return new IOResult(this.openFiles.get(handle).pread(len, offset));
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public IOResult pwrite(int handle, int len, long offset) {
        try {
            this.openFiles.get(handle).pwrite(len, offset, true);
            return new IOResult();
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public IOResult lseek(int handle, long offset, int whence) {
        try {
            return new IOResult(this.openFiles.get(handle).lseek(offset, whence));
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public IOResult size(int handle) {
        try {
            return new IOResult(this.openFiles.get(handle).size());
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public IOResult ftruncate(int handle, long length) {
        try {
            this.openFiles.get(handle).ftruncate(length);
            return new IOResult();
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }

    @Override
    public IOResult sync(int handle, boolean metadata) {
        try {
            this.openFiles.get(handle).sync(metadata);
            return new IOResult();
        }
        catch (ErrnoException | IOException e) {
            return new IOResult(e);
        }
    }
}

