/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.Binder;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.OpenFile;
import java.io.IOException;

class FileContainer {
    private static final String ERROR_MSG = "Requested file was not opened!";
    private int nextHandle = 0;
    private final SparseArray<SparseArray<OpenFile>> files = new SparseArray();

    FileContainer() {
    }

    @NonNull
    synchronized OpenFile get(int handle) throws IOException {
        int pid = Binder.getCallingPid();
        SparseArray pidFiles = (SparseArray)this.files.get(pid);
        if (pidFiles == null) {
            throw new IOException(ERROR_MSG);
        }
        OpenFile h = (OpenFile)pidFiles.get(handle);
        if (h == null) {
            throw new IOException(ERROR_MSG);
        }
        return h;
    }

    synchronized int put(OpenFile h) {
        int pid = Binder.getCallingPid();
        SparseArray pidFiles = (SparseArray)this.files.get(pid);
        if (pidFiles == null) {
            pidFiles = new SparseArray();
            this.files.put(pid, (Object)pidFiles);
        }
        int handle = this.nextHandle++;
        pidFiles.append(handle, (Object)h);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void remove(int handle) {
        int pid = Binder.getCallingPid();
        SparseArray pidFiles = (SparseArray)this.files.get(pid);
        if (pidFiles == null) {
            return;
        }
        OpenFile h = (OpenFile)pidFiles.get(handle);
        if (h == null) {
            return;
        }
        pidFiles.remove(handle);
        OpenFile openFile = h;
        synchronized (openFile) {
            h.close();
        }
    }

    synchronized void pidDied(int pid) {
        SparseArray pidFiles = (SparseArray)this.files.get(pid);
        if (pidFiles == null) {
            return;
        }
        this.files.remove(pid);
        for (int i = 0; i < pidFiles.size(); ++i) {
            ((OpenFile)pidFiles.valueAt(i)).close();
        }
    }
}

