/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2okhttp;

import android.util.Log;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2okhttp.OkHttpUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u00192\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001f0\u000bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020!H\u0016J\u0012\u0010$\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\rH\u0002J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060,H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0019H\u0016J\u0018\u00100\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u00102\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u00103\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060,2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00065"}, d2={"Lcom/tonyodev/fetch2okhttp/OkHttpDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "Lokhttp3/OkHttpClient;", "Lokhttp3/Request;", "okHttpClient", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "<init>", "(Lokhttp3/OkHttpClient;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "Lokhttp3/Response;", "client", "getClient", "()Lokhttp3/OkHttpClient;", "setClient", "(Lokhttp3/OkHttpClient;)V", "onPreClientExecute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "getRedirectedServerRequest", "oldRequest", "redirectUrl", "", "execute", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getContentHash", "responseHeaders", "", "disconnect", "", "response", "close", "closeResponse", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "verifyContentHash", "", "hash", "onServerResponse", "getHeadRequestMethodSupported", "getRequestBufferSize", "getRequestContentLength", "getRequestSupportedFileDownloaderTypes", "fetch2okhttp_release"})
@SourceDebugExtension(value={"SMAP\nOkHttpDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpDownloader.kt\ncom/tonyodev/fetch2okhttp/OkHttpDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1863#2,2:211\n1863#2,2:213\n*S KotlinDebug\n*F\n+ 1 OkHttpDownloader.kt\ncom/tonyodev/fetch2okhttp/OkHttpDownloader\n*L\n47#1:211,2\n153#1:213,2\n*E\n"})
public class OkHttpDownloader
implements Downloader<OkHttpClient, Request> {
    @NotNull
    private final Downloader.FileDownloaderType fileDownloaderType;
    @NotNull
    private final Map<Downloader.Response, Response> connections;
    @NotNull
    private volatile OkHttpClient client;

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkNotNullParameter((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.connections = map;
        OkHttpClient okHttpClient2 = okHttpClient;
        if (okHttpClient2 == null) {
            okHttpClient2 = new OkHttpClient.Builder().readTimeout(20000L, TimeUnit.MILLISECONDS).connectTimeout(15000L, TimeUnit.MILLISECONDS).cache(null).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(false).cookieJar(OkHttpUtils.getDefaultCookieJar()).build();
        }
        this.client = okHttpClient2;
    }

    public /* synthetic */ OkHttpDownloader(OkHttpClient okHttpClient, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            okHttpClient = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(okHttpClient, fileDownloaderType);
    }

    public OkHttpDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkNotNullParameter((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"<set-?>");
        this.client = okHttpClient;
    }

    @NotNull
    public Request onPreClientExecute(@NotNull OkHttpClient client, @NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(request.getUrl()).method(request.getRequestMethod(), null);
        Iterable $this$forEach$iv = request.getHeaders().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            okHttpRequestBuilder.addHeader((String)it.getKey(), (String)it.getValue());
        }
        return okHttpRequestBuilder.build();
    }

    private final Downloader.ServerRequest getRedirectedServerRequest(Downloader.ServerRequest oldRequest, String redirectUrl) {
        return new Downloader.ServerRequest(oldRequest.getId(), oldRequest.getUrl(), oldRequest.getHeaders(), oldRequest.getFile(), oldRequest.getFileUri(), oldRequest.getTag(), oldRequest.getIdentifier(), oldRequest.getRequestMethod(), oldRequest.getExtras(), true, redirectUrl, oldRequest.getSegment());
    }

    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)interruptMonitor, (String)"interruptMonitor");
        Request okHttpRequest = this.onPreClientExecute(this.client, request);
        if (okHttpRequest.header("Referer") == null) {
            String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
            okHttpRequest = okHttpRequest.newBuilder().addHeader("Referer", referer).build();
        }
        Response okHttpResponse = this.client.newCall(okHttpRequest).execute();
        Map responseHeaders = okHttpResponse.headers().toMultimap();
        int code = okHttpResponse.code();
        if ((code == 302 || code == 301 || code == 303) && FetchCoreUtils.getHeaderValue((Map)responseHeaders, (String[])(stringArray = new String[]{"Location"})) != null) {
            String[] stringArray2 = new String[]{"Location"};
            String string = FetchCoreUtils.getHeaderValue((Map)responseHeaders, (String[])stringArray2);
            if (string == null) {
                string = "";
            }
            if ((okHttpRequest = this.onPreClientExecute(this.client, this.getRedirectedServerRequest(request, string))).header("Referer") == null) {
                String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
                okHttpRequest = okHttpRequest.newBuilder().addHeader("Referer", referer).build();
            }
            try {
                okHttpResponse.close();
            }
            catch (Exception e) {
                Log.d((String)e.getMessage(), (String)"Failed executing request.");
            }
            okHttpResponse = this.client.newCall(okHttpRequest).execute();
            responseHeaders = okHttpResponse.headers().toMultimap();
            code = okHttpResponse.code();
        }
        boolean success = okHttpResponse.isSuccessful();
        long contentLength = FetchCoreUtils.getContentLengthFromHeader((Map)responseHeaders, (long)-1L);
        ResponseBody responseBody = okHttpResponse.body();
        InputStream byteStream = responseBody != null ? responseBody.byteStream() : null;
        String errorResponseString = !success ? FetchCoreUtils.copyStreamToString((InputStream)byteStream, (boolean)false) : null;
        String hash = this.getContentHash(MapsKt.toMutableMap((Map)responseHeaders));
        boolean acceptsRanges = FetchCoreUtils.acceptRanges((int)code, (Map)responseHeaders);
        this.onServerResponse(request, new Downloader.Response(code, success, contentLength, null, request, hash, responseHeaders, acceptsRanges, errorResponseString));
        Downloader.Response response = new Downloader.Response(code, success, contentLength, byteStream, request, hash, responseHeaders, acceptsRanges, errorResponseString);
        this.connections.put(response, okHttpResponse);
        return response;
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        String[] stringArray = new String[]{"Content-MD5"};
        String string = FetchCoreUtils.getHeaderValue(responseHeaders, (String[])stringArray);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void disconnect(@NotNull Downloader.Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this.connections.containsKey(response)) {
            Response okHttpResponse = this.connections.get(response);
            this.connections.remove(response);
            this.closeResponse(okHttpResponse);
        }
    }

    public void close() {
        Iterable $this$forEach$iv = this.connections.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.closeResponse((Response)it.getValue());
        }
        this.connections.clear();
    }

    private final void closeResponse(Response response) {
        try {
            Response response2 = response;
            if (response2 != null) {
                response2.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        String fileMd5;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (((CharSequence)hash).length() == 0) {
            return true;
        }
        String string = fileMd5 = FetchCoreUtils.getFileMd5String((String)request.getFile());
        return string != null ? string.contentEquals(hash) : true;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)this);
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.fileDownloaderType == Downloader.FileDownloaderType.SEQUENTIAL) {
            Object[] objectArray = new Downloader.FileDownloaderType[]{this.fileDownloaderType};
            return SetsKt.mutableSetOf((Object[])objectArray);
        }
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)this);
        }
        catch (Exception e) {
            Object[] objectArray = new Downloader.FileDownloaderType[]{this.fileDownloaderType};
            set = SetsKt.mutableSetOf((Object[])objectArray);
        }
        return set;
    }

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient) {
        this(okHttpClient, null, 2, null);
    }

    @JvmOverloads
    public OkHttpDownloader() {
        this(null, null, 3, null);
    }
}

