/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.regexp;

import com.google.code.regexp.GroupInfo;
import com.google.code.regexp.NamedMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedPattern {
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<(\\w+)>");
    private Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;
    private Map<String, List<GroupInfo>> groupInfo;

    public static NamedPattern compile(String regex) {
        return new NamedPattern(regex, 0);
    }

    public static NamedPattern compile(String regex, int flags) {
        return new NamedPattern(regex, flags);
    }

    private NamedPattern(String regex, int flags) {
        this.namedPattern = regex;
        this.pattern = NamedPattern.buildStandardPattern(regex, flags);
        this.groupInfo = NamedPattern.extractGroupInfo(regex);
    }

    public int indexOf(String groupName) {
        return this.indexOf(groupName, 0);
    }

    public int indexOf(String groupName, int index) {
        List<GroupInfo> list;
        int idx = -1;
        if (this.groupInfo.containsKey(groupName) && index < (list = this.groupInfo.get(groupName)).size()) {
            idx = list.get(index).groupIndex();
        }
        return idx;
    }

    public int flags() {
        return this.pattern.flags();
    }

    public NamedMatcher matcher(CharSequence input) {
        return new NamedMatcher(this, input);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public String standardPattern() {
        return this.pattern.pattern();
    }

    public String namedPattern() {
        return this.namedPattern;
    }

    public List<String> groupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>(this.groupInfo.keySet());
        }
        return this.groupNames;
    }

    public Map<String, List<GroupInfo>> groupInfo() {
        return this.groupInfo;
    }

    public String[] split(CharSequence input, int limit) {
        return this.pattern.split(input, limit);
    }

    public String[] split(CharSequence input) {
        return this.pattern.split(input);
    }

    public String toString() {
        return this.namedPattern;
    }

    private static boolean isEscapedParen(String s, int pos) {
        return pos > 0 && s.charAt(pos - 1) == '\\';
    }

    private static boolean isNoncapturingParen(String s, int pos) {
        int len = s.length();
        boolean isLookbehind = false;
        if (pos >= 0 && pos + 4 < len) {
            String pre = s.substring(pos, pos + 4);
            isLookbehind = pre.equals("(?<=") || pre.equals("(?<!");
        }
        return pos >= 0 && pos + 2 < len && s.charAt(pos + 1) == '?' && (isLookbehind || s.charAt(pos + 2) != '<');
    }

    private static int countOpenParens(String s, int pos) {
        Pattern p = Pattern.compile("\\(");
        Matcher m = p.matcher(s.subSequence(0, pos));
        int numParens = 0;
        while (m.find()) {
            String match = m.group(0);
            if (NamedPattern.isEscapedParen(s, m.start()) || !match.equals("(") || NamedPattern.isNoncapturingParen(s, m.start())) continue;
            ++numParens;
        }
        return numParens;
    }

    public static Map<String, List<GroupInfo>> extractGroupInfo(String namedPattern) {
        LinkedHashMap<String, List<GroupInfo>> groupInfo = new LinkedHashMap<String, List<GroupInfo>>();
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            int pos = matcher.start();
            if (NamedPattern.isEscapedParen(namedPattern, pos)) continue;
            String name = matcher.group(1);
            int groupIndex = NamedPattern.countOpenParens(namedPattern, pos);
            List list = groupInfo.containsKey(name) ? (List)groupInfo.get(name) : new ArrayList();
            list.add(new GroupInfo(groupIndex, pos));
            groupInfo.put(name, list);
        }
        return groupInfo;
    }

    private static Pattern buildStandardPattern(String namedPattern, Integer flags) {
        return Pattern.compile(NAMED_GROUP_PATTERN.matcher(namedPattern).replaceAll("("), flags);
    }
}

