/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.regexp;

import com.google.code.regexp.NamedMatchResult;
import com.google.code.regexp.NamedPattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedMatcher
implements NamedMatchResult {
    private Matcher matcher;
    private NamedPattern parentPattern;

    NamedMatcher() {
    }

    NamedMatcher(NamedPattern parentPattern, MatchResult matcher) {
        this.parentPattern = parentPattern;
        this.matcher = (Matcher)matcher;
    }

    NamedMatcher(NamedPattern parentPattern, CharSequence input) {
        this.parentPattern = parentPattern;
        this.matcher = parentPattern.pattern().matcher(input);
    }

    public Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public NamedPattern namedPattern() {
        return this.parentPattern;
    }

    public NamedMatcher usePattern(NamedPattern newPattern) {
        this.parentPattern = newPattern;
        this.matcher.usePattern(newPattern.pattern());
        return this;
    }

    public NamedMatcher reset() {
        this.matcher.reset();
        return this;
    }

    public NamedMatcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public NamedMatchResult toMatchResult() {
        return new NamedMatcher(this.parentPattern, this.matcher.toMatchResult());
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) {
        return this.matcher.find(start);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    public NamedMatcher appendReplacement(StringBuffer sb, String replacement) {
        this.matcher.appendReplacement(sb, replacement);
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public List<String> orderedGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        int groupCount = this.groupCount();
        for (int i = 1; i <= groupCount; ++i) {
            groups.add(this.group(i));
        }
        return groups;
    }

    @Override
    public String group(String groupName) {
        return this.group(this.groupIndex(groupName));
    }

    @Override
    public Map<String, String> namedGroups() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int groupCount = Math.min(this.groupCount(), this.parentPattern.groupNames().size());
        for (int i = 1; i <= groupCount; ++i) {
            String groupName = this.parentPattern.groupNames().get(i - 1);
            String groupValue = this.matcher.group(i);
            result.put(groupName, groupValue);
        }
        return result;
    }

    private int groupIndex(String groupName) {
        int idx = this.parentPattern.indexOf(groupName);
        return idx > -1 ? idx + 1 : -1;
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int start(String groupName) {
        return this.start(this.groupIndex(groupName));
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public int end(String groupName) {
        return this.end(this.groupIndex(groupName));
    }

    public NamedMatcher region(int start, int end) {
        this.matcher.region(start, end);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceFirst(String replacement) {
        return this.matcher.replaceFirst(replacement);
    }

    public NamedMatcher useAnchoringBounds(boolean b) {
        this.matcher.useAnchoringBounds(b);
        return this;
    }

    public NamedMatcher useTransparentBounds(boolean b) {
        this.matcher.useTransparentBounds(b);
        return this;
    }

    public boolean equals(Object obj) {
        return this.matcher.equals(obj);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }
}

