/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateParser;
import ch.qos.logback.core.rolling.helper.FileFinder;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FileProvider;
import ch.qos.logback.core.rolling.helper.FileSorter;
import ch.qos.logback.core.rolling.helper.IntParser;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected final FileNamePattern fileNamePattern;
    private final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    private final FileProvider fileProvider;
    private final FileSorter fileSorter;
    private final DateParser dateParser;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc, FileProvider fileProvider) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rc;
        this.fileProvider = fileProvider;
        this.dateParser = new DateParser(fileNamePattern);
        this.fileSorter = new FileSorter(this.dateParser, new IntParser(fileNamePattern));
    }

    @Override
    public void clean(Date now) {
        List<String> files = this.findFiles();
        List<String> expiredFiles = this.filterFiles(files, this.createExpiredFileFilter(now));
        for (String f : expiredFiles) {
            this.delete(new File(f));
        }
        if (this.totalSizeCap != 0L && this.totalSizeCap > 0L) {
            this.capTotalSize(files);
        }
        List<String> emptyDirs = this.findEmptyDirs();
        for (String dir : emptyDirs) {
            this.delete(new File(dir));
        }
    }

    private boolean delete(File file) {
        this.addInfo("deleting " + file);
        boolean ok = this.fileProvider.deleteFile(file);
        if (!ok) {
            this.addWarn("cannot delete " + file);
        }
        return ok;
    }

    private void capTotalSize(List<String> filenames) {
        long totalSize = 0L;
        long totalRemoved = 0L;
        String[] fnames = filenames.toArray(new String[0]);
        this.fileSorter.sort(fnames);
        for (String name : fnames) {
            File f = new File(name);
            long size = this.fileProvider.length(f);
            if (totalSize + size > this.totalSizeCap) {
                this.addInfo("Deleting [" + f + "] of size " + new FileSize(size));
                if (!this.delete(f)) {
                    size = 0L;
                }
                totalRemoved += size;
            }
            totalSize += size;
        }
        this.addInfo("Removed  " + new FileSize(totalRemoved) + " of files");
    }

    @Override
    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    @Override
    public void setTotalSizeCap(long totalSizeCap) {
        this.totalSizeCap = totalSizeCap;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date now) {
        ArchiveRemoverRunnable runnable = new ArchiveRemoverRunnable(now);
        ScheduledExecutorService executorService = this.context.getScheduledExecutorService();
        return executorService.submit(runnable);
    }

    private FilenameFilter createExpiredFileFilter(final Date baseDate) {
        return new FilenameFilter(){

            public boolean accept(File dir, String path) {
                Date fileDate = TimeBasedArchiveRemover.this.dateParser.parseFilename(path);
                fileDate = TimeBasedArchiveRemover.this.rc.normalizeDate(fileDate);
                Date refDate = TimeBasedArchiveRemover.this.rc.getEndOfNextNthPeriod(baseDate, -TimeBasedArchiveRemover.this.maxHistory);
                refDate = TimeBasedArchiveRemover.this.rc.normalizeDate(refDate);
                return fileDate.compareTo(refDate) < 0;
            }
        };
    }

    private List<String> filterFiles(List<String> filenames, FilenameFilter filter) {
        ArrayList<String> matchedFiles = new ArrayList<String>();
        for (String f : filenames.toArray(new String[0])) {
            if (!filter.accept(null, f)) continue;
            matchedFiles.add(f);
            filenames.remove(f);
        }
        return matchedFiles;
    }

    private List<String> findFiles() {
        return new FileFinder(this.fileProvider).findFiles(this.fileNamePattern.toRegex());
    }

    private List<String> findEmptyDirs() {
        List<String> dirList = new FileFinder(this.fileProvider).findDirs(this.fileNamePattern.toRegex());
        Collections.reverse(dirList);
        ArrayDeque<String> emptyDirs = new ArrayDeque<String>();
        for (String dir : dirList) {
            int childSize = this.fileProvider.list(new File(dir), null).length;
            if (childSize != 0 && (childSize != 1 || emptyDirs.size() <= 0 || !dir.equals(emptyDirs.peekLast()))) continue;
            emptyDirs.add(dir);
        }
        return Arrays.asList(emptyDirs.toArray(new String[0]));
    }

    private class ArchiveRemoverRunnable
    implements Runnable {
        Date now;

        ArchiveRemoverRunnable(Date now) {
            this.now = now;
        }

        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
        }
    }
}

