/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.AbstractIncludeAction;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class IncludeAction
extends AbstractIncludeAction {
    private static final String INCLUDED_TAG = "included";
    private static final String CONFIG_TAG = "configuration";
    private int eventOffset = 2;

    protected void setEventOffset(int offset) {
        this.eventOffset = offset;
    }

    protected SaxEventRecorder createRecorder(InputStream in, URL url) {
        return new SaxEventRecorder(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInclude(InterpretationContext ic, URL url) throws JoranException {
        InputStream in = this.openURL(url);
        try {
            if (in != null) {
                ConfigurationWatchListUtil.addToWatchList(this.getContext(), url);
                SaxEventRecorder recorder = this.createRecorder(in, url);
                recorder.setContext(this.getContext());
                recorder.recordEvents(in);
                this.trimHeadAndTail(recorder);
                ic.getJoranInterpreter().getEventPlayer().addEventsDynamically(recorder.getSaxEventList(), this.eventOffset);
            }
        }
        catch (JoranException e) {
            this.optionalWarning("Failed processing [" + url.toString() + "]", e);
        }
        finally {
            this.close(in);
        }
    }

    private InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            this.optionalWarning("Failed to open [" + url.toString() + "]", e);
            return null;
        }
    }

    private void trimHeadAndTail(SaxEventRecorder recorder) {
        List<SaxEvent> saxEventList = recorder.getSaxEventList();
        if (saxEventList.size() == 0) {
            return;
        }
        boolean includedTagFound = false;
        boolean configTagFound = false;
        SaxEvent first = saxEventList.get(0);
        if (first != null) {
            String elemName = this.getEventName(first);
            includedTagFound = INCLUDED_TAG.equalsIgnoreCase(elemName);
            configTagFound = CONFIG_TAG.equalsIgnoreCase(elemName);
        }
        if (includedTagFound || configTagFound) {
            saxEventList.remove(0);
            int listSize = saxEventList.size();
            if (listSize == 0) {
                return;
            }
            int lastIndex = listSize - 1;
            SaxEvent last = saxEventList.get(lastIndex);
            if (last != null) {
                String elemName = this.getEventName(last);
                if (includedTagFound && INCLUDED_TAG.equalsIgnoreCase(elemName) || configTagFound && CONFIG_TAG.equalsIgnoreCase(elemName)) {
                    saxEventList.remove(lastIndex);
                }
            }
        }
    }

    private String getEventName(SaxEvent event) {
        return event.qName.length() > 0 ? event.qName : event.localName;
    }
}

