/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import java.lang.reflect.Method;

public class SystemPropertiesProxy {
    private static final SystemPropertiesProxy SINGLETON = new SystemPropertiesProxy(null);
    private Class<?> SystemProperties;
    private Method getString;
    private Method getBoolean;

    private SystemPropertiesProxy(ClassLoader cl) {
        try {
            this.setClassLoader(cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SystemPropertiesProxy getInstance() {
        return SINGLETON;
    }

    public void setClassLoader(ClassLoader cl) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.SystemProperties = cl.loadClass("android.os.SystemProperties");
        this.getString = this.SystemProperties.getMethod("get", String.class, String.class);
        this.getBoolean = this.SystemProperties.getMethod("getBoolean", String.class, Boolean.TYPE);
    }

    public String get(String key, String def) throws IllegalArgumentException {
        if (this.SystemProperties == null || this.getString == null) {
            return null;
        }
        String ret = null;
        try {
            ret = (String)this.getString.invoke(this.SystemProperties, key, def);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null || ret.length() == 0) {
            ret = def;
        }
        return ret;
    }

    public Boolean getBoolean(String key, boolean def) throws IllegalArgumentException {
        if (this.SystemProperties == null || this.getBoolean == null) {
            return def;
        }
        Boolean ret = def;
        try {
            ret = (Boolean)this.getBoolean.invoke(this.SystemProperties, key, def);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

