/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.LogcatAppender;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import org.slf4j.LoggerFactory;

public class BasicLogcatConfigurator {
    private BasicLogcatConfigurator() {
    }

    public static void configure(LoggerContext lc) {
        StatusManager sm = lc.getStatusManager();
        if (sm != null) {
            sm.add(new InfoStatus("Setting up default configuration.", lc));
        }
        LogcatAppender appender = new LogcatAppender();
        appender.setContext(lc);
        appender.setName("logcat");
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext(lc);
        pl.setPattern("%msg");
        pl.start();
        appender.setEncoder(pl);
        appender.start();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.addAppender(appender);
    }

    public static void configureDefaultContext() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        BasicLogcatConfigurator.configure(lc);
    }
}

