/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.NOPOutputStream;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppender<E>
extends OutputStreamAppender<E> {
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private boolean initialized = false;
    private boolean lazyInit = false;

    public void setFile(String file) {
        this.fileName = file == null ? null : file.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int errors = 0;
        String file = this.getFile();
        if (file != null) {
            file = this.getAbsoluteFilePath(file);
            this.addInfo("File property is set to [" + file + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (!this.lazyInit) {
                try {
                    this.openFile(file);
                }
                catch (IOException e) {
                    ++errors;
                    this.addError("openFile(" + file + "," + this.append + ") failed", e);
                }
            } else {
                this.setOutputStream(new NOPOutputStream());
            }
        } else {
            ++errors;
            this.addError("\"File\" property not set for appender named [" + this.name + "]");
        }
        if (errors == 0) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean openFile(String filename) throws IOException {
        boolean successful = false;
        filename = this.getAbsoluteFilePath(filename);
        LogbackLock logbackLock = this.lock;
        synchronized (logbackLock) {
            boolean result;
            File file = new File(filename);
            if (FileUtil.isParentDirectoryCreationRequired(file) && !(result = FileUtil.createMissingParentDirectories(file))) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFos = new ResilientFileOutputStream(file, this.append);
            resilientFos.setContext(this.context);
            this.setOutputStream(resilientFos);
            successful = true;
        }
        return successful;
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean prudent) {
        this.prudent = prudent;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean getLazy() {
        return this.lazyInit;
    }

    public void setLazy(boolean enable) {
        this.lazyInit = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E event) throws IOException {
        ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFOS.getChannel();
        if (fileChannel == null) {
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long position = fileChannel.position();
            long size = fileChannel.size();
            if (size != position) {
                fileChannel.position(size);
            }
            super.writeOut(event);
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
        }
    }

    @Override
    protected void writeOut(E event) throws IOException {
        if (this.prudent) {
            this.safeWrite(event);
        } else {
            super.writeOut(event);
        }
    }

    @Override
    protected void subAppend(E event) {
        if (!this.initialized && this.lazyInit) {
            this.initialized = true;
            try {
                this.openFile(this.getFile());
            }
            catch (IOException e) {
                this.started = false;
                this.addError("openFile(" + this.fileName + "," + this.append + ") failed", e);
            }
        }
        super.subAppend(event);
    }

    private String getAbsoluteFilePath(String filename) {
        if (EnvUtil.isAndroidOS() && !new File(filename).isAbsolute()) {
            String dataDir = this.context.getProperty("DATA_DIR");
            filename = FileUtil.prefixRelativePath(dataDir, filename);
        }
        return filename;
    }
}

