/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.OptionHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvUtil {
    private static final Pattern versionPattern = Pattern.compile("^(1\\.)?([0-9]+)");

    private EnvUtil() {
    }

    public static boolean isAndroidOS() {
        String string = OptionHelper.getSystemProperty("os.name");
        String string2 = OptionHelper.getEnv("ANDROID_ROOT");
        String string3 = OptionHelper.getEnv("ANDROID_DATA");
        return string != null && string.contains("Linux") && string2 != null && string2.contains("/system") && string3 != null && string3.contains("/data");
    }

    private static boolean isJDK_N_OrHigher(int n) {
        Matcher matcher = versionPattern.matcher(System.getProperty("java.version", ""));
        if (matcher.find()) {
            return n <= Integer.parseInt(matcher.group(2));
        }
        return false;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }
}

