/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    @Override
    public void clean(Date date) {
        long l = date.getTime();
        int n = this.computeElapsedPeriodsSinceLastClean(l);
        this.lastHeartBeat = l;
        if (n > 1) {
            this.addInfo("Multiple periods, i.e. " + n + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.getPeriodOffsetForDeletionTarget() - i;
            Date date2 = this.rc.getEndOfNextNthPeriod(date, n2);
            this.cleanPeriod(date2);
        }
    }

    protected File[] getFilesInPeriod(Date date) {
        String string = this.fileNamePattern.convert(date);
        File file = new File(string);
        if (this.fileExistsAndIsFile(file)) {
            return new File[]{file};
        }
        return new File[0];
    }

    private boolean fileExistsAndIsFile(File file) {
        return file.exists() && file.isFile();
    }

    public void cleanPeriod(Date date) {
        File[] fileArray;
        for (File file : fileArray = this.getFilesInPeriod(date)) {
            this.addInfo("deleting " + file);
            file.delete();
        }
        if (this.parentClean && fileArray.length > 0) {
            File file = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty(file);
        }
    }

    void capTotalSize(Date date) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.maxHistory; ++i) {
            Date date2 = this.rc.getEndOfNextNthPeriod(date, -i);
            File[] fileArray = this.getFilesInPeriod(date2);
            this.descendingSort(fileArray, date2);
            for (File file : fileArray) {
                long l3 = file.length();
                if (l + l3 > this.totalSizeCap) {
                    this.addInfo("Deleting [" + file + "] of size " + new FileSize(l3));
                    l2 += l3;
                    file.delete();
                }
                l += l3;
            }
        }
        this.addInfo("Removed  " + new FileSize(l2) + " of files");
    }

    protected void descendingSort(File[] fileArray, Date date) {
    }

    File getParentDir(File file) {
        File file2 = file.getAbsoluteFile();
        File file3 = file2.getParentFile();
        return file3;
    }

    int computeElapsedPeriodsSinceLastClean(long l) {
        long l2 = 0L;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            l2 = this.rc.periodBarriersCrossed(l, l + 2764800000L);
            l2 = Math.min(l2, 336L);
        } else {
            l2 = this.rc.periodBarriersCrossed(this.lastHeartBeat, l);
        }
        return (int)l2;
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> converter;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = fileNamePattern.headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            String string;
            if (converter instanceof LiteralConverter && (string = converter.convert(null)).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n) {
        if (n >= 3) {
            return;
        }
        if (file.isDirectory() && FileFilterUtil.isEmptyDirectory(file)) {
            this.addInfo("deleting folder [" + file + "]");
            file.delete();
            this.removeFolderIfEmpty(file.getParentFile(), n + 1);
        }
    }

    @Override
    public void setMaxHistory(int n) {
        this.maxHistory = n;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    @Override
    public void setTotalSizeCap(long l) {
        this.totalSizeCap = l;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date date) {
        ArhiveRemoverRunnable arhiveRemoverRunnable = new ArhiveRemoverRunnable(date);
        ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
        Future<?> future = scheduledExecutorService.submit(arhiveRemoverRunnable);
        return future;
    }

    public class ArhiveRemoverRunnable
    implements Runnable {
        Date now;

        ArhiveRemoverRunnable(Date date) {
            this.now = date;
        }

        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
            if (TimeBasedArchiveRemover.this.totalSizeCap != 0L && TimeBasedArchiveRemover.this.totalSizeCap > 0L) {
                TimeBasedArchiveRemover.this.capTotalSize(this.now);
            }
        }
    }
}

