/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerContext context;
    ObjectInputStream ois;
    SocketAddress remoteSocketAddress;
    Logger logger;
    boolean closed = false;
    SimpleSocketServer socketServer;

    public SocketNode(SimpleSocketServer simpleSocketServer, Socket socket, LoggerContext loggerContext) {
        this.socketServer = simpleSocketServer;
        this.socket = socket;
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.context = loggerContext;
        this.logger = loggerContext.getLogger(SocketNode.class);
    }

    public void run() {
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception exception) {
            this.logger.error("Could not open ObjectInputStream to " + this.socket, exception);
            this.closed = true;
        }
        try {
            while (!this.closed) {
                ILoggingEvent iLoggingEvent = (ILoggingEvent)this.ois.readObject();
                Logger logger = this.context.getLogger(iLoggingEvent.getLoggerName());
                if (!logger.isEnabledFor(iLoggingEvent.getLevel())) continue;
                logger.callAppenders(iLoggingEvent);
            }
        }
        catch (EOFException eOFException) {
            this.logger.info("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException socketException) {
            this.logger.info("Caught java.net.SocketException closing connection.");
        }
        catch (IOException iOException) {
            this.logger.info("Caught java.io.IOException: " + iOException);
            this.logger.info("Closing connection.");
        }
        catch (Exception exception) {
            this.logger.error("Unexpected exception. Closing connection.", exception);
        }
        this.socketServer.socketNodeClosing(this);
        this.close();
    }

    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ois != null) {
            try {
                this.ois.close();
            }
            catch (IOException iOException) {
                this.logger.warn("Could not close connection.", iOException);
            }
            finally {
                this.ois = null;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + this.remoteSocketAddress.toString();
    }
}

