/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStatusManager
implements StatusManager {
    public static final int MAX_HEADER_COUNT = 150;
    public static final int TAIL_SIZE = 150;
    int count = 0;
    protected final List<Status> statusList = new ArrayList<Status>();
    protected final CyclicBuffer<Status> tailBuffer = new CyclicBuffer(150);
    protected final LogbackLock statusListLock = new LogbackLock();
    int level = 0;
    protected final List<StatusListener> statusListenerList = new ArrayList<StatusListener>();
    protected final LogbackLock statusListenerListLock = new LogbackLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Status status) {
        this.fireStatusAddEvent(status);
        ++this.count;
        if (status.getLevel() > this.level) {
            this.level = status.getLevel();
        }
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            if (this.statusList.size() < 150) {
                this.statusList.add(status);
            } else {
                this.tailBuffer.add(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Status> getCopyOfStatusList() {
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            ArrayList<Status> arrayList = new ArrayList<Status>(this.statusList);
            arrayList.addAll(this.tailBuffer.asList());
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusAddEvent(Status status) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            for (StatusListener statusListener : this.statusListenerList) {
                statusListener.addStatusEvent(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            this.count = 0;
            this.statusList.clear();
            this.tailBuffer.clear();
        }
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StatusListener statusListener) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            boolean bl;
            if (statusListener instanceof OnConsoleStatusListener && (bl = this.checkForPresence(this.statusListenerList, statusListener.getClass()))) {
                return;
            }
            this.statusListenerList.add(statusListener);
        }
    }

    private boolean checkForPresence(List<StatusListener> list, Class<?> clazz) {
        for (StatusListener statusListener : list) {
            if (statusListener.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addUniquely(StatusListener statusListener, Object object) {
        for (StatusListener statusListener2 : this.getCopyOfStatusListenerList()) {
            if (!statusListener2.getClass().isInstance(statusListener)) continue;
            this.add(new WarnStatus("A previous listener of type [" + statusListener2.getClass() + "] has been already registered. Skipping double registration.", object));
            return false;
        }
        this.add(statusListener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StatusListener statusListener) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            this.statusListenerList.remove(statusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatusListener> getCopyOfStatusListenerList() {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            return new ArrayList<StatusListener>(this.statusListenerList);
        }
    }
}

