/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SyslogStartConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timesmapStr = null;
    SimpleDateFormat simpleFormat;
    final String localHostName = "localhost";
    int facility;

    public void start() {
        int n = 0;
        String string = this.getFirstOption();
        if (string == null) {
            this.addError("was expecting a facility string as an option");
            return;
        }
        this.facility = SyslogAppenderBase.facilityStringToint(string);
        try {
            this.simpleFormat = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);
            this.simpleFormat.setDateFormatSymbols(new DateFormatSymbols(Locale.US));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addError("Could not instantiate SimpleDateFormat", illegalArgumentException);
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.facility + LevelToSyslogSeverity.convert(iLoggingEvent);
        stringBuilder.append("<");
        stringBuilder.append(n);
        stringBuilder.append(">");
        stringBuilder.append(this.computeTimeStampString(iLoggingEvent.getTimeStamp()));
        stringBuilder.append(' ');
        stringBuilder.append("localhost");
        stringBuilder.append(' ');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String computeTimeStampString(long l) {
        SyslogStartConverter syslogStartConverter = this;
        synchronized (syslogStartConverter) {
            if (l != this.lastTimestamp) {
                this.lastTimestamp = l;
                this.timesmapStr = this.simpleFormat.format(new Date(l));
            }
            return this.timesmapStr;
        }
    }
}

