/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncement;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAudioFocusManager;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayerProvider;
import timber.log.Timber;

class NavigationSpeechListener
implements SpeechListener {
    private SpeechPlayerProvider speechPlayerProvider;
    private SpeechAudioFocusManager audioFocusManager;

    NavigationSpeechListener(SpeechPlayerProvider speechPlayerProvider, SpeechAudioFocusManager audioFocusManager) {
        this.speechPlayerProvider = speechPlayerProvider;
        this.audioFocusManager = audioFocusManager;
    }

    @Override
    public void onStart() {
        this.audioFocusManager.requestAudioFocus();
    }

    @Override
    public void onDone() {
        this.audioFocusManager.abandonAudioFocus();
    }

    @Override
    public void onError(String errorText, SpeechAnnouncement speechAnnouncement) {
        Timber.e((String)errorText, (Object[])new Object[0]);
        this.speechPlayerProvider.retrieveAndroidSpeechPlayer().play(speechAnnouncement);
    }
}

