/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.summary.list;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.summary.list.InstructionListPresenter;
import com.mapbox.services.android.navigation.ui.v5.summary.list.InstructionViewHolder;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;

public class InstructionListAdapter
extends RecyclerView.Adapter<InstructionViewHolder> {
    private final InstructionListPresenter presenter;

    public InstructionListAdapter(RouteUtils routeUtils, DistanceFormatter distanceFormatter) {
        this.presenter = new InstructionListPresenter(routeUtils, distanceFormatter);
    }

    @NonNull
    public InstructionViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.instruction_viewholder_layout, parent, false);
        return new InstructionViewHolder(view);
    }

    public void onBindViewHolder(@NonNull InstructionViewHolder holder, int position) {
        this.presenter.onBindInstructionListViewAtPosition(position, holder);
    }

    public int getItemCount() {
        return this.presenter.retrieveBannerInstructionListSize();
    }

    public void onViewDetachedFromWindow(@NonNull InstructionViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.itemView.clearAnimation();
    }

    public void updateBannerListWith(RouteProgress routeProgress, boolean isListShowing) {
        boolean didUpdate = this.presenter.updateBannerListWith(routeProgress);
        if (didUpdate && isListShowing) {
            this.notifyDataSetChanged();
        }
    }

    public void updateDistanceFormatter(DistanceFormatter distanceFormatter) {
        this.presenter.updateDistanceFormatter(distanceFormatter);
    }
}

