/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.route.FeatureProcessingTask;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteDrawableProvider;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteLayerProvider;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteSourceProvider;
import com.mapbox.services.android.navigation.ui.v5.route.OnPrimaryRouteUpdatedCallback;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteFeaturesProcessedCallback;
import com.mapbox.services.android.navigation.ui.v5.route.PrimaryRouteUpdateTask;
import com.mapbox.services.android.navigation.ui.v5.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class MapRouteLine {
    @ColorInt
    private int routeDefaultColor;
    @ColorInt
    private int routeModerateColor;
    @ColorInt
    private int routeSevereColor;
    @ColorInt
    private int alternativeRouteDefaultColor;
    @ColorInt
    private int alternativeRouteModerateColor;
    @ColorInt
    private int alternativeRouteSevereColor;
    @ColorInt
    private int alternativeRouteShieldColor;
    @ColorInt
    private int routeShieldColor;
    private float routeScale;
    private float alternativeRouteScale;
    private boolean roundedLineCap;
    private final HashMap<LineString, DirectionsRoute> routeLineStrings = new HashMap();
    private final List<FeatureCollection> routeFeatureCollections = new ArrayList<FeatureCollection>();
    private final List<DirectionsRoute> directionsRoutes = new ArrayList<DirectionsRoute>();
    private final List<Layer> routeLayers;
    private MapboxMap mapboxMap;
    private Drawable originIcon;
    private Drawable destinationIcon;
    private GeoJsonSource wayPointSource;
    private GeoJsonSource routeLineSource;
    private String belowLayer;
    private int primaryRouteIndex;
    private boolean isVisible = true;
    private boolean alternativesVisible = true;
    private OnRouteFeaturesProcessedCallback routeFeaturesProcessedCallback = new OnRouteFeaturesProcessedCallback(){

        @Override
        public void onRouteFeaturesProcessed(List<FeatureCollection> routeFeatureCollections, HashMap<LineString, DirectionsRoute> routeLineStrings) {
            MapRouteLine.this.routeFeatureCollections.addAll(routeFeatureCollections);
            MapRouteLine.this.routeLineStrings.putAll(routeLineStrings);
            MapRouteLine.this.drawRoutes(routeFeatureCollections);
            MapRouteLine.this.drawWayPoints();
            MapRouteLine.this.updateAlternativeVisibilityTo(MapRouteLine.this.alternativesVisible);
            MapRouteLine.this.updateRoutesFor(MapRouteLine.this.primaryRouteIndex);
            MapRouteLine.this.updateVisibilityTo(MapRouteLine.this.isVisible);
        }
    };
    private OnPrimaryRouteUpdatedCallback primaryRouteUpdatedCallback = new OnPrimaryRouteUpdatedCallback(){

        @Override
        public void onPrimaryRouteUpdated(List<FeatureCollection> updatedRouteCollections) {
            MapRouteLine.this.drawRoutes(updatedRouteCollections);
        }
    };

    MapRouteLine(Context context, MapboxMap mapboxMap, int styleRes, String belowLayer, MapRouteDrawableProvider drawableProvider, MapRouteSourceProvider sourceProvider, MapRouteLayerProvider layerProvider) {
        this.mapboxMap = mapboxMap;
        this.belowLayer = belowLayer;
        this.routeLayers = new ArrayList<Layer>();
        TypedArray typedArray = context.obtainStyledAttributes(styleRes, R.styleable.NavigationMapRoute);
        this.routeDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_blue));
        this.routeModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_yellow));
        this.routeSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_red));
        this.routeShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_shield_layer_color));
        this.routeScale = typedArray.getFloat(R.styleable.NavigationMapRoute_routeScale, 1.0f);
        this.roundedLineCap = typedArray.getBoolean(R.styleable.NavigationMapRoute_roundedLineCap, true);
        this.alternativeRouteDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_color));
        this.alternativeRouteModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_yellow));
        this.alternativeRouteSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_red));
        this.alternativeRouteShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_shield_color));
        this.alternativeRouteScale = typedArray.getFloat(R.styleable.NavigationMapRoute_alternativeRouteScale, 1.0f);
        int originWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_originWaypointIcon, R.drawable.ic_route_origin);
        int destinationWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_destinationWaypointIcon, R.drawable.ic_route_destination);
        typedArray.recycle();
        this.originIcon = drawableProvider.retrieveDrawable(originWaypointIcon);
        this.destinationIcon = drawableProvider.retrieveDrawable(destinationWaypointIcon);
        this.findRouteBelowLayerId();
        GeoJsonOptions wayPointGeoJsonOptions = new GeoJsonOptions().withMaxZoom(16);
        FeatureCollection emptyWayPointFeatureCollection = FeatureCollection.fromFeatures((Feature[])new Feature[0]);
        this.wayPointSource = sourceProvider.build("mapbox-navigation-waypoint-source", emptyWayPointFeatureCollection, wayPointGeoJsonOptions);
        mapboxMap.getStyle().addSource((Source)this.wayPointSource);
        GeoJsonOptions routeLineGeoJsonOptions = new GeoJsonOptions().withMaxZoom(16);
        FeatureCollection emptyRouteLineFeatureCollection = FeatureCollection.fromFeatures((Feature[])new Feature[0]);
        this.routeLineSource = sourceProvider.build("mapbox-navigation-route-source", emptyRouteLineFeatureCollection, routeLineGeoJsonOptions);
        mapboxMap.getStyle().addSource((Source)this.routeLineSource);
        this.initializeLayers(mapboxMap, layerProvider);
    }

    MapRouteLine(GeoJsonSource routeLineSource, GeoJsonSource wayPointSource, List<Layer> routeLayers) {
        this.routeLineSource = routeLineSource;
        this.wayPointSource = wayPointSource;
        this.routeLayers = routeLayers;
    }

    void draw(DirectionsRoute directionsRoute) {
        ArrayList<DirectionsRoute> route = new ArrayList<DirectionsRoute>();
        route.add(directionsRoute);
        this.draw(route);
    }

    void draw(List<DirectionsRoute> directionsRoutes) {
        if (directionsRoutes.isEmpty()) {
            return;
        }
        this.clearRouteData();
        this.directionsRoutes.addAll(directionsRoutes);
        this.primaryRouteIndex = 0;
        this.alternativesVisible = directionsRoutes.size() > 1;
        this.isVisible = true;
        this.generateRouteFeatureCollectionsFrom(directionsRoutes);
    }

    void redraw(List<DirectionsRoute> routes, boolean alternativesVisible, int primaryRouteIndex, boolean isVisible) {
        this.draw(routes);
        this.alternativesVisible = alternativesVisible;
        this.primaryRouteIndex = primaryRouteIndex;
        this.isVisible = isVisible;
    }

    void toggleAlternativeVisibilityWith(boolean alternativesVisible) {
        this.alternativesVisible = alternativesVisible;
        this.updateAlternativeVisibilityTo(alternativesVisible);
    }

    boolean retrieveAlternativesVisible() {
        return this.alternativesVisible;
    }

    void updateVisibilityTo(boolean isVisible) {
        this.updateAllLayersVisibilityTo(isVisible);
    }

    boolean retrieveVisibility() {
        return this.isVisible;
    }

    HashMap<LineString, DirectionsRoute> retrieveRouteLineStrings() {
        return this.routeLineStrings;
    }

    List<DirectionsRoute> retrieveDirectionsRoutes() {
        return this.directionsRoutes;
    }

    boolean updatePrimaryRouteIndex(int primaryRouteIndex) {
        boolean isNewIndex;
        boolean bl = isNewIndex = this.primaryRouteIndex != primaryRouteIndex && primaryRouteIndex < this.directionsRoutes.size() && primaryRouteIndex >= 0;
        if (isNewIndex) {
            this.primaryRouteIndex = primaryRouteIndex;
            this.updateRoutesFor(primaryRouteIndex);
        }
        return isNewIndex;
    }

    int retrievePrimaryRouteIndex() {
        return this.primaryRouteIndex;
    }

    private void drawRoutes(List<FeatureCollection> routeFeatureCollections) {
        ArrayList routeFeatures = new ArrayList();
        for (int i = routeFeatureCollections.size() - 1; i >= 0; --i) {
            routeFeatures.addAll(routeFeatureCollections.get(i).features());
        }
        this.routeLineSource.setGeoJson(FeatureCollection.fromFeatures(routeFeatures));
    }

    private void clearRouteData() {
        this.clearRouteListData();
        this.resetSource(this.wayPointSource);
        this.resetSource(this.routeLineSource);
    }

    private void clearRouteListData() {
        if (!this.directionsRoutes.isEmpty()) {
            this.directionsRoutes.clear();
        }
        if (!this.routeLineStrings.isEmpty()) {
            this.routeLineStrings.clear();
        }
        if (!this.routeFeatureCollections.isEmpty()) {
            this.routeFeatureCollections.clear();
        }
    }

    private void generateRouteFeatureCollectionsFrom(List<DirectionsRoute> routes) {
        new FeatureProcessingTask(routes, this.routeFeaturesProcessedCallback).execute(new Void[0]);
    }

    private void drawWayPoints() {
        DirectionsRoute primaryRoute = this.directionsRoutes.get(this.primaryRouteIndex);
        FeatureCollection wayPointFeatureCollection = this.buildWayPointFeatureCollectionFrom(primaryRoute);
        this.wayPointSource.setGeoJson(wayPointFeatureCollection);
    }

    private FeatureCollection buildWayPointFeatureCollectionFrom(DirectionsRoute route) {
        ArrayList<Feature> wayPointFeatures = new ArrayList<Feature>();
        for (RouteLeg leg : route.legs()) {
            wayPointFeatures.add(this.buildWayPointFeatureFromLeg(leg, 0));
            wayPointFeatures.add(this.buildWayPointFeatureFromLeg(leg, leg.steps().size() - 1));
        }
        return FeatureCollection.fromFeatures(wayPointFeatures);
    }

    private Feature buildWayPointFeatureFromLeg(RouteLeg leg, int index) {
        Feature feature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)((LegStep)leg.steps().get(index)).maneuver().location().longitude(), (double)((LegStep)leg.steps().get(index)).maneuver().location().latitude()));
        feature.addStringProperty("wayPoint", index == 0 ? "origin" : "destination");
        return feature;
    }

    private void updateRoutesFor(int newPrimaryIndex) {
        if (newPrimaryIndex < 0 || newPrimaryIndex > this.routeFeatureCollections.size() - 1) {
            return;
        }
        new PrimaryRouteUpdateTask(newPrimaryIndex, this.routeFeatureCollections, this.primaryRouteUpdatedCallback).execute(new Void[0]);
    }

    private void findRouteBelowLayerId() {
        if (this.belowLayer == null || this.belowLayer.isEmpty()) {
            List styleLayers = this.mapboxMap.getStyle().getLayers();
            for (int i = 0; i < styleLayers.size(); ++i) {
                if (styleLayers.get(i) instanceof SymbolLayer || ((Layer)styleLayers.get(i)).getId().contains("mapbox-location")) continue;
                this.belowLayer = ((Layer)styleLayers.get(i)).getId();
            }
        }
    }

    private void initializeLayers(MapboxMap mapboxMap, MapRouteLayerProvider layerProvider) {
        LineLayer routeShieldLayer = layerProvider.initializeRouteShieldLayer(mapboxMap, this.routeScale, this.alternativeRouteScale, this.routeShieldColor, this.alternativeRouteShieldColor);
        MapUtils.addLayerToMap(mapboxMap, (Layer)routeShieldLayer, this.belowLayer);
        this.routeLayers.add((Layer)routeShieldLayer);
        LineLayer routeLayer = layerProvider.initializeRouteLayer(mapboxMap, this.roundedLineCap, this.routeScale, this.alternativeRouteScale, this.routeDefaultColor, this.routeModerateColor, this.routeSevereColor, this.alternativeRouteDefaultColor, this.alternativeRouteModerateColor, this.alternativeRouteSevereColor);
        MapUtils.addLayerToMap(mapboxMap, (Layer)routeLayer, this.belowLayer);
        this.routeLayers.add((Layer)routeLayer);
        SymbolLayer wayPointLayer = layerProvider.initializeWayPointLayer(mapboxMap, this.originIcon, this.destinationIcon);
        MapUtils.addLayerToMap(mapboxMap, (Layer)wayPointLayer, this.belowLayer);
        this.routeLayers.add((Layer)wayPointLayer);
    }

    private void updateAlternativeVisibilityTo(boolean isVisible) {
        for (Layer layer : this.routeLayers) {
            String layerId = layer.getId();
            if (!layerId.equals("mapbox-navigation-route-layer") && !layerId.equals("mapbox-navigation-route-shield-layer")) continue;
            LineLayer route = (LineLayer)layer;
            if (isVisible) {
                route.setFilter(Expression.literal((boolean)true));
                continue;
            }
            route.setFilter(Expression.eq((Expression)Expression.get((String)"primary-route"), (boolean)true));
        }
    }

    private void updateAllLayersVisibilityTo(boolean isVisible) {
        this.isVisible = isVisible;
        for (Layer layer : this.routeLayers) {
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)(isVisible ? "visible" : "none"))});
        }
    }

    private void resetSource(GeoJsonSource source) {
        source.setGeoJson(FeatureCollection.fromFeatures((Feature[])new Feature[0]));
    }
}

