/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.services.android.navigation.ui.v5.utils.MapImageUtils;

class MapRouteLayerProvider {
    MapRouteLayerProvider() {
    }

    LineLayer initializeRouteShieldLayer(MapboxMap mapboxMap, float routeScale, float alternativeRouteScale, int routeShieldColor, int alternativeRouteShieldColor) {
        LineLayer shieldLayer = (LineLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-route-shield-layer");
        if (shieldLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)shieldLayer);
        }
        shieldLayer = new LineLayer("mapbox-navigation-route-shield-layer", "mapbox-navigation-route-source").withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(7.0f)), Expression.stop((Object)Float.valueOf(14.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(10.5f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(16.5f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(15.5f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(19.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(24.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(22.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(29.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})}))})), PropertyFactory.lineColor((Expression)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.color((int)routeShieldColor), Expression.color((int)alternativeRouteShieldColor)}))});
        return shieldLayer;
    }

    LineLayer initializeRouteLayer(MapboxMap mapboxMap, boolean roundedLineCap, float routeScale, float alternativeRouteScale, int routeDefaultColor, int routeModerateColor, int routeSevereColor, int alternativeRouteDefaultColor, int alternativeRouteModerateColor, int alternativeRouteSevereColor) {
        LineLayer routeLayer = (LineLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-route-layer");
        if (routeLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)routeLayer);
        }
        String lineCap = "round";
        String lineJoin = "round";
        if (!roundedLineCap) {
            lineCap = "butt";
            lineJoin = "bevel";
        }
        routeLayer = new LineLayer("mapbox-navigation-route-layer", "mapbox-navigation-route-source").withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)lineCap), PropertyFactory.lineJoin((String)lineJoin), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(4.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(3.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(10.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(4.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(13.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(6.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(16.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(10.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(19.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(14.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(22.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(18.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(routeScale)), Expression.literal((Number)Float.valueOf(alternativeRouteScale))})}))})), PropertyFactory.lineColor((Expression)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"congestion")), (Expression)Expression.color((int)routeDefaultColor), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)routeModerateColor)), Expression.stop((Object)"heavy", (Object)Expression.color((int)routeSevereColor)), Expression.stop((Object)"severe", (Object)Expression.color((int)routeSevereColor))}), Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"congestion")), (Expression)Expression.color((int)alternativeRouteDefaultColor), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)alternativeRouteModerateColor)), Expression.stop((Object)"heavy", (Object)Expression.color((int)alternativeRouteSevereColor)), Expression.stop((Object)"severe", (Object)Expression.color((int)alternativeRouteSevereColor))})}))});
        return routeLayer;
    }

    SymbolLayer initializeWayPointLayer(@NonNull MapboxMap mapboxMap, Drawable originIcon, Drawable destinationIcon) {
        SymbolLayer wayPointLayer = (SymbolLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-waypoint-layer");
        if (wayPointLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)wayPointLayer);
        }
        Bitmap bitmap = MapImageUtils.getBitmapFromDrawable(originIcon);
        mapboxMap.getStyle().addImage("originMarker", bitmap);
        bitmap = MapImageUtils.getBitmapFromDrawable(destinationIcon);
        mapboxMap.getStyle().addImage("destinationMarker", bitmap);
        wayPointLayer = new SymbolLayer("mapbox-navigation-waypoint-layer", "mapbox-navigation-waypoint-source").withProperties(new PropertyValue[]{PropertyFactory.iconImage((Expression)Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"wayPoint")), (Expression)Expression.literal((String)"originMarker"), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"origin", (Object)Expression.literal((String)"originMarker")), Expression.stop((Object)"destination", (Object)Expression.literal((String)"destinationMarker"))})), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.6f)), Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(0.8f)), Expression.stop((Object)Float.valueOf(12.0f), (Object)Float.valueOf(1.3f)), Expression.stop((Object)Float.valueOf(22.0f), (Object)Float.valueOf(2.8f))})), PropertyFactory.iconPitchAlignment((String)"map"), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true)});
        return wayPointLayer;
    }
}

