/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.os.AsyncTask;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteFeaturesProcessedCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class FeatureProcessingTask
extends AsyncTask<Void, Void, Void> {
    private final List<DirectionsRoute> routes;
    private final List<FeatureCollection> routeFeatureCollections = new ArrayList<FeatureCollection>();
    private final WeakReference<OnRouteFeaturesProcessedCallback> callbackWeakReference;
    private final HashMap<LineString, DirectionsRoute> routeLineStrings = new HashMap();

    FeatureProcessingTask(List<DirectionsRoute> routes, OnRouteFeaturesProcessedCallback callback) {
        this.routes = routes;
        this.callbackWeakReference = new WeakReference<OnRouteFeaturesProcessedCallback>(callback);
    }

    protected Void doInBackground(Void ... voids) {
        for (int i = 0; i < this.routes.size(); ++i) {
            DirectionsRoute route = this.routes.get(i);
            boolean isPrimary = i == 0;
            FeatureCollection routeFeatureCollection = this.createRouteFeatureCollection(route, isPrimary);
            this.routeFeatureCollections.add(routeFeatureCollection);
        }
        return null;
    }

    protected void onPostExecute(Void result) {
        super.onPostExecute((Object)result);
        Runtime.getRuntime().gc();
        OnRouteFeaturesProcessedCallback callback = (OnRouteFeaturesProcessedCallback)this.callbackWeakReference.get();
        if (callback != null) {
            callback.onRouteFeaturesProcessed(this.routeFeatureCollections, this.routeLineStrings);
        }
    }

    private FeatureCollection createRouteFeatureCollection(DirectionsRoute route, boolean isPrimary) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        LineString routeGeometry = LineString.fromPolyline((String)route.geometry(), (int)6);
        Feature routeFeature = Feature.fromGeometry((Geometry)routeGeometry);
        routeFeature.addBooleanProperty("primary-route", Boolean.valueOf(isPrimary));
        features.add(routeFeature);
        this.routeLineStrings.put(routeGeometry, route);
        List<Feature> congestionFeatures = this.buildCongestionFeaturesFromRoute(route, routeGeometry, isPrimary);
        features.addAll(congestionFeatures);
        return FeatureCollection.fromFeatures(features);
    }

    private List<Feature> buildCongestionFeaturesFromRoute(DirectionsRoute route, LineString lineString, boolean isPrimary) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (RouteLeg leg : route.legs()) {
            if (leg.annotation() != null && leg.annotation().congestion() != null) {
                for (int i = 0; i < leg.annotation().congestion().size(); ++i) {
                    if (leg.annotation().congestion().size() + 1 > lineString.coordinates().size()) continue;
                    ArrayList points = new ArrayList();
                    points.add(lineString.coordinates().get(i));
                    points.add(lineString.coordinates().get(i + 1));
                    LineString congestionLineString = LineString.fromLngLats(points);
                    Feature feature = Feature.fromGeometry((Geometry)congestionLineString);
                    String congestionValue = (String)leg.annotation().congestion().get(i);
                    feature.addStringProperty("congestion", congestionValue);
                    feature.addBooleanProperty("primary-route", Boolean.valueOf(isPrimary));
                    features.add(feature);
                }
                continue;
            }
            Feature feature = Feature.fromGeometry((Geometry)lineString);
            features.add(feature);
        }
        return features;
    }
}

