/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction.turnlane;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.services.android.navigation.ui.v5.instruction.turnlane.TurnLaneDrawableMap;
import com.mapbox.services.android.navigation.ui.v5.instruction.turnlane.TurnLaneViewData;

public class TurnLaneView
extends AppCompatImageView {
    private static final float HALF_OPACITY = 0.4f;
    private static final float FULL_OPACITY = 1.0f;
    private static final int SCALE_FLIPPED = -1;
    private static final int SCALE_NORMAL = 1;
    private final TurnLaneDrawableMap laneDrawableMap = new TurnLaneDrawableMap();

    public TurnLaneView(Context context) {
        super(context);
    }

    public TurnLaneView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public TurnLaneView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void updateLaneView(@NonNull BannerComponents lane, @NonNull String maneuverModifier) {
        if (this.hasInvalidData(lane)) {
            return;
        }
        TurnLaneViewData drawData = this.buildTurnLaneViewData(lane, maneuverModifier);
        Integer resId = this.findDrawableResId(drawData);
        if (resId == null) {
            return;
        }
        this.drawFor(lane, drawData, resId);
    }

    private boolean hasInvalidData(@NonNull BannerComponents lane) {
        return lane.directions() == null || lane.active() == null;
    }

    @NonNull
    private TurnLaneViewData buildTurnLaneViewData(@NonNull BannerComponents lane, @NonNull String maneuverModifier) {
        StringBuilder builder = new StringBuilder();
        for (String indication : lane.directions()) {
            builder.append(indication);
        }
        String laneIndications = builder.toString();
        return new TurnLaneViewData(laneIndications, maneuverModifier);
    }

    @Nullable
    private Integer findDrawableResId(TurnLaneViewData drawData) {
        String drawMethod = drawData.getDrawMethod();
        Integer resId = (Integer)this.laneDrawableMap.get(drawMethod);
        if (resId == null) {
            return null;
        }
        return resId;
    }

    private void drawFor(@NonNull BannerComponents lane, TurnLaneViewData drawData, Integer resId) {
        VectorDrawableCompat turnLaneDrawable = VectorDrawableCompat.create((Resources)this.getResources(), (int)resId, (Resources.Theme)this.getContext().getTheme());
        this.setImageDrawable((Drawable)turnLaneDrawable);
        this.setAlpha(lane.active() == false ? 0.4f : 1.0f);
        this.setScaleX(drawData.shouldBeFlipped() ? -1.0f : 1.0f);
    }
}

