/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.widget.TextView;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.services.android.navigation.ui.v5.instruction.AbbreviationVerifier;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerComponentNode;
import com.mapbox.services.android.navigation.ui.v5.instruction.NodeCreator;
import com.mapbox.services.android.navigation.ui.v5.instruction.TextViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AbbreviationCreator
extends NodeCreator<AbbreviationNode, AbbreviationVerifier> {
    private static final String SINGLE_SPACE = " ";
    private Map<Integer, List<Integer>> abbreviations;
    private TextViewUtils textViewUtils;

    AbbreviationCreator(AbbreviationVerifier abbreviationVerifier, HashMap abbreviations, TextViewUtils textViewUtils) {
        super(abbreviationVerifier);
        this.abbreviations = abbreviations;
        this.textViewUtils = textViewUtils;
    }

    AbbreviationCreator(AbbreviationVerifier abbreviationVerifier) {
        this(abbreviationVerifier, new HashMap(), new TextViewUtils());
    }

    AbbreviationCreator() {
        this(new AbbreviationVerifier());
    }

    private void addPriorityInfo(BannerComponents bannerComponents, int index) {
        Integer abbreviationPriority = bannerComponents.abbreviationPriority();
        if (this.abbreviations.get(abbreviationPriority) == null) {
            this.abbreviations.put(abbreviationPriority, new ArrayList());
        }
        this.abbreviations.get(abbreviationPriority).add(index);
    }

    private String abbreviateBannerText(TextView textView, List<BannerComponentNode> bannerComponentNodes) {
        String bannerText = this.join(bannerComponentNodes);
        if (this.abbreviations.isEmpty()) {
            return bannerText;
        }
        bannerText = this.abbreviateUntilTextFits(textView, bannerText, bannerComponentNodes);
        this.abbreviations.clear();
        return bannerText;
    }

    private String abbreviateUntilTextFits(TextView textView, String startingText, List<BannerComponentNode> bannerComponentNodes) {
        int currAbbreviationPriority = 0;
        int maxAbbreviationPriority = Collections.max(this.abbreviations.keySet());
        String bannerText = startingText;
        while (this.shouldKeepAbbreviating(textView, bannerText, currAbbreviationPriority, maxAbbreviationPriority)) {
            List<Integer> indices;
            boolean abbreviationPriorityExists;
            if (!(abbreviationPriorityExists = this.abbreviateAtAbbreviationPriority(bannerComponentNodes, indices = this.abbreviations.get(currAbbreviationPriority++)))) continue;
            bannerText = this.join(bannerComponentNodes);
        }
        return bannerText;
    }

    private boolean shouldKeepAbbreviating(TextView textView, String bannerText, int currAbbreviationPriority, int maxAbbreviationPriority) {
        boolean textFits = this.textViewUtils.textFits(textView, bannerText);
        boolean abbreviationPrioritiesLeft = currAbbreviationPriority <= maxAbbreviationPriority;
        return !textFits && abbreviationPrioritiesLeft;
    }

    private boolean abbreviateAtAbbreviationPriority(List<BannerComponentNode> bannerComponentNodes, List<Integer> indices) {
        if (indices == null || indices.isEmpty()) {
            return false;
        }
        for (Integer index : indices) {
            this.abbreviate(bannerComponentNodes.get(index));
        }
        return true;
    }

    private void abbreviate(BannerComponentNode bannerComponentNode) {
        ((AbbreviationNode)bannerComponentNode).setAbbreviate(true);
    }

    private String join(List<BannerComponentNode> tokens) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<BannerComponentNode> iterator = tokens.iterator();
        if (iterator.hasNext()) {
            BannerComponentNode bannerComponentNode = iterator.next();
            bannerComponentNode.setStartIndex(stringBuilder.length());
            stringBuilder.append(bannerComponentNode);
            while (iterator.hasNext()) {
                stringBuilder.append(SINGLE_SPACE);
                bannerComponentNode = iterator.next();
                bannerComponentNode.setStartIndex(stringBuilder.length());
                stringBuilder.append(bannerComponentNode);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    AbbreviationNode setupNode(BannerComponents components, int index, int startIndex, String modifier) {
        this.addPriorityInfo(components, index);
        return new AbbreviationNode(components, startIndex);
    }

    @Override
    void preProcess(TextView textView, List<BannerComponentNode> bannerComponentNodes) {
        String text = this.abbreviateBannerText(textView, bannerComponentNodes);
        textView.setText((CharSequence)text);
    }

    static class AbbreviationNode
    extends BannerComponentNode {
        private boolean abbreviate;

        AbbreviationNode(BannerComponents bannerComponents, int startIndex) {
            super(bannerComponents, startIndex);
        }

        @Override
        public String toString() {
            return this.abbreviate ? this.bannerComponents.abbreviation() : this.bannerComponents.text();
        }

        void setAbbreviate(boolean abbreviate) {
            this.abbreviate = abbreviate;
        }

        boolean getAbbreviate() {
            return this.abbreviate;
        }
    }
}

