/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.feedback;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackAdapter;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackBottomSheetListener;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackClickListener;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;

public class FeedbackBottomSheet
extends BottomSheetDialogFragment
implements FeedbackClickListener.ClickCallback,
Animator.AnimatorListener {
    public static final String TAG = FeedbackBottomSheet.class.getSimpleName();
    private FeedbackBottomSheetListener feedbackBottomSheetListener;
    private FeedbackAdapter feedbackAdapter;
    private RecyclerView feedbackItems;
    private ProgressBar feedbackProgressBar;
    private ObjectAnimator countdownAnimation;
    private long duration;

    public static FeedbackBottomSheet newInstance(FeedbackBottomSheetListener feedbackBottomSheetListener, long duration) {
        FeedbackBottomSheet feedbackBottomSheet = new FeedbackBottomSheet();
        feedbackBottomSheet.setFeedbackBottomSheetListener(feedbackBottomSheetListener);
        feedbackBottomSheet.setDuration(duration);
        feedbackBottomSheet.setRetainInstance(true);
        return feedbackBottomSheet;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(2, R.style.Theme_Design_BottomSheetDialog);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.feedback_bottom_sheet_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.bind(view);
        this.initFeedbackRecyclerView();
        this.initCountDownAnimation();
        this.initBackground(view);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        BottomSheetDialog dialog = (BottomSheetDialog)super.onCreateDialog(savedInstanceState);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                BottomSheetDialog bottomSheetDialog = (BottomSheetDialog)dialog;
                FrameLayout bottomSheet = (FrameLayout)bottomSheetDialog.findViewById(R.id.design_bottom_sheet);
                if (bottomSheet != null) {
                    BottomSheetBehavior behavior = BottomSheetBehavior.from((View)bottomSheet);
                    behavior.setState(3);
                    behavior.setSkipCollapsed(true);
                }
            }
        });
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.feedbackBottomSheetListener.onFeedbackDismissed();
    }

    public void onDestroyView() {
        this.removeListener();
        this.removeDialogDismissMessage();
        this.cancelCountdownAnimation();
        super.onDestroyView();
    }

    @Override
    public void onFeedbackItemClick(int feedbackPosition) {
        FeedbackItem feedbackItem = this.feedbackAdapter.getFeedbackItem(feedbackPosition);
        this.feedbackBottomSheetListener.onFeedbackSelected(feedbackItem);
        this.dismiss();
    }

    public void onAnimationEnd(Animator animation) {
        this.dismiss();
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void setFeedbackBottomSheetListener(FeedbackBottomSheetListener feedbackBottomSheetListener) {
        this.feedbackBottomSheetListener = feedbackBottomSheetListener;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    private void bind(View bottomSheetView) {
        this.feedbackItems = (RecyclerView)bottomSheetView.findViewById(R.id.feedbackItems);
        this.feedbackProgressBar = (ProgressBar)bottomSheetView.findViewById(R.id.feedbackProgress);
    }

    private void initFeedbackRecyclerView() {
        Context context = this.getContext();
        this.feedbackAdapter = new FeedbackAdapter(context);
        this.feedbackItems.setAdapter((RecyclerView.Adapter)this.feedbackAdapter);
        this.feedbackItems.setOverScrollMode(1);
        this.feedbackItems.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new FeedbackClickListener(context, this));
        if (context.getResources().getConfiguration().orientation == 2) {
            this.feedbackItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 0, false));
        } else {
            this.feedbackItems.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, 3));
        }
    }

    private void initCountDownAnimation() {
        this.countdownAnimation = ObjectAnimator.ofInt((Object)this.feedbackProgressBar, (String)"progress", (int[])new int[]{0});
        this.countdownAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.countdownAnimation.setDuration(this.duration);
        this.countdownAnimation.addListener((Animator.AnimatorListener)this);
        this.countdownAnimation.start();
    }

    private void initBackground(View view) {
        if (Build.VERSION.SDK_INT < 21) {
            int navigationViewPrimaryColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewPrimary);
            int navigationViewSecondaryColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewSecondary);
            Drawable bottomSheetBackground = DrawableCompat.wrap((Drawable)view.getBackground()).mutate();
            DrawableCompat.setTint((Drawable)bottomSheetBackground, (int)navigationViewPrimaryColor);
            LayerDrawable progressBarBackground = (LayerDrawable)this.feedbackProgressBar.getProgressDrawable();
            Drawable progressDrawable = progressBarBackground.getDrawable(1);
            progressDrawable.setColorFilter(navigationViewSecondaryColor, PorterDuff.Mode.SRC_IN);
        }
    }

    private void removeListener() {
        this.feedbackBottomSheetListener = null;
    }

    private void removeDialogDismissMessage() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.getRetainInstance()) {
            dialog.setDismissMessage(null);
        }
    }

    private void cancelCountdownAnimation() {
        if (this.countdownAnimation != null) {
            this.countdownAnimation.removeAllListeners();
            this.countdownAnimation.cancel();
        }
    }
}

