/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.TranslateAnimation;
import com.mapbox.services.android.navigation.ui.v5.MultiOnClickListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationButton;
import com.mapbox.services.android.navigation.ui.v5.R;

public class RecenterButton
extends CardView
implements NavigationButton {
    private MultiOnClickListener multiOnClickListener = new MultiOnClickListener();
    private Animation slideUpBottom;

    public RecenterButton(Context context) {
        this(context, null);
    }

    public RecenterButton(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public RecenterButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @Override
    public void show() {
        if (this.getVisibility() == 4) {
            this.setVisibility(0);
            this.startAnimation(this.slideUpBottom);
        }
    }

    @Override
    public void addOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.addListener(onClickListener);
    }

    @Override
    public void removeOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.removeListener(onClickListener);
    }

    @Override
    public void hide() {
        if (this.getVisibility() == 0) {
            this.setVisibility(4);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initAnimation();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setupOnClickListeners();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearListeners();
    }

    private void setupOnClickListeners() {
        this.setOnClickListener(this.multiOnClickListener);
    }

    private void clearListeners() {
        this.multiOnClickListener.clearListeners();
        this.multiOnClickListener = null;
        this.setOnClickListener(null);
    }

    private void init() {
        RecenterButton.inflate((Context)this.getContext(), (int)R.layout.recenter_btn_layout, (ViewGroup)this);
    }

    private void initAnimation() {
        this.slideUpBottom = new TranslateAnimation(0.0f, 0.0f, 125.0f, 0.0f);
        this.slideUpBottom.setDuration(300L);
        this.slideUpBottom.setInterpolator((Interpolator)new OvershootInterpolator(2.0f));
    }
}

