/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.services.android.navigation.ui.v5.ConnectivityStatusProvider;
import com.mapbox.services.android.navigation.ui.v5.LocationEngineConductor;
import com.mapbox.services.android.navigation.ui.v5.MapConnectivityController;
import com.mapbox.services.android.navigation.ui.v5.MapOfflineManager;
import com.mapbox.services.android.navigation.ui.v5.MapOfflineOptions;
import com.mapbox.services.android.navigation.ui.v5.NavigationOfflineDatabaseCallback;
import com.mapbox.services.android.navigation.ui.v5.NavigationUiOptions;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewEventDispatcher;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModelProgressChangeListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewRouteEngineListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewRouter;
import com.mapbox.services.android.navigation.ui.v5.OfflineMetadataProvider;
import com.mapbox.services.android.navigation.ui.v5.OfflineRegionDefinitionProvider;
import com.mapbox.services.android.navigation.ui.v5.RegionDownloadCallback;
import com.mapbox.services.android.navigation.ui.v5.ViewRouteListener;
import com.mapbox.services.android.navigation.ui.v5.VoiceInstructionCache;
import com.mapbox.services.android.navigation.ui.v5.camera.DynamicCamera;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerInstructionModel;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionModel;
import com.mapbox.services.android.navigation.ui.v5.summary.SummaryModel;
import com.mapbox.services.android.navigation.ui.v5.voice.NavigationSpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncement;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayerProvider;
import com.mapbox.services.android.navigation.ui.v5.voice.VoiceInstructionLoader;
import com.mapbox.services.android.navigation.v5.milestone.BannerInstructionMilestone;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.MilestoneEventListener;
import com.mapbox.services.android.navigation.v5.milestone.VoiceInstructionMilestone;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventListener;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteListener;
import com.mapbox.services.android.navigation.v5.route.FasterRouteListener;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import java.io.File;
import java.util.List;
import okhttp3.Cache;

public class NavigationViewModel
extends AndroidViewModel {
    private static final String EMPTY_STRING = "";
    private static final String OKHTTP_INSTRUCTION_CACHE = "okhttp-instruction-cache";
    private static final long TEN_MEGABYTE_CACHE_SIZE = 0xA00000L;
    public final MutableLiveData<InstructionModel> instructionModel = new MutableLiveData();
    public final MutableLiveData<BannerInstructionModel> bannerInstructionModel = new MutableLiveData();
    public final MutableLiveData<SummaryModel> summaryModel = new MutableLiveData();
    public final MutableLiveData<Boolean> isOffRoute = new MutableLiveData();
    final MutableLiveData<Location> navigationLocation = new MutableLiveData();
    final MutableLiveData<DirectionsRoute> route = new MutableLiveData();
    final MutableLiveData<Boolean> shouldRecordScreenshot = new MutableLiveData();
    private final MutableLiveData<Point> destination = new MutableLiveData();
    private MapboxNavigation navigation;
    private NavigationViewRouter router;
    private LocationEngineConductor locationEngineConductor;
    private NavigationViewEventDispatcher navigationViewEventDispatcher;
    private SpeechPlayer speechPlayer;
    private VoiceInstructionLoader voiceInstructionLoader;
    private VoiceInstructionCache voiceInstructionCache;
    private int voiceInstructionsToAnnounce = 0;
    private RouteProgress routeProgress;
    private String feedbackId;
    private String screenshot;
    private String language;
    private RouteUtils routeUtils;
    private LocaleUtils localeUtils;
    private DistanceFormatter distanceFormatter;
    private String accessToken;
    private int timeFormatType;
    private boolean isRunning;
    private boolean isChangingConfigurations;
    private MapConnectivityController connectivityController;
    private MapOfflineManager mapOfflineManager;
    private OffRouteListener offRouteListener = new OffRouteListener(){

        public void userOffRoute(Location location) {
            NavigationViewModel.this.speechPlayer.onOffRoute();
            Point newOrigin = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
            NavigationViewModel.this.handleOffRouteEvent(newOrigin, location.getBearing());
        }
    };
    private MilestoneEventListener milestoneEventListener = new MilestoneEventListener(){

        public void onMilestoneEvent(RouteProgress routeProgress, String instruction, Milestone milestone) {
            NavigationViewModel.this.voiceInstructionCache.cache();
            NavigationViewModel.this.playVoiceAnnouncement(milestone);
            NavigationViewModel.this.updateBannerInstruction(routeProgress, milestone);
        }
    };
    private NavigationEventListener navigationEventListener = new NavigationEventListener(){

        public void onRunning(boolean isRunning) {
            NavigationViewModel.this.isRunning = isRunning;
            NavigationViewModel.this.sendNavigationStatusEvent(isRunning);
        }
    };
    private FasterRouteListener fasterRouteListener = new FasterRouteListener(){

        public void fasterRouteFound(DirectionsRoute directionsRoute) {
            NavigationViewModel.this.updateRoute(directionsRoute);
        }
    };
    private ViewRouteListener routeEngineListener = new NavigationViewRouteEngineListener(this);

    public NavigationViewModel(Application application) {
        super(application);
        this.accessToken = Mapbox.getAccessToken();
        this.initializeLocationEngine();
        this.initializeRouter();
        this.routeUtils = new RouteUtils();
        this.localeUtils = new LocaleUtils();
        this.connectivityController = new MapConnectivityController();
    }

    NavigationViewModel(Application application, MapboxNavigation navigation, MapConnectivityController connectivityController, MapOfflineManager mapOfflineManager) {
        super(application);
        this.navigation = navigation;
        this.connectivityController = connectivityController;
        this.mapOfflineManager = mapOfflineManager;
    }

    NavigationViewModel(Application application, MapboxNavigation navigation, LocationEngineConductor conductor, NavigationViewEventDispatcher dispatcher, VoiceInstructionCache cache, SpeechPlayer speechPlayer) {
        super(application);
        this.navigation = navigation;
        this.locationEngineConductor = conductor;
        this.navigationViewEventDispatcher = dispatcher;
        this.voiceInstructionCache = cache;
        this.speechPlayer = speechPlayer;
    }

    public void onDestroy(boolean isChangingConfigurations) {
        this.isChangingConfigurations = isChangingConfigurations;
        if (!isChangingConfigurations) {
            this.destroyRouter();
            this.endNavigation();
            this.destroyMapOffline();
            this.deactivateInstructionPlayer();
            this.isRunning = false;
        }
        this.clearDynamicCameraMap();
        this.navigationViewEventDispatcher = null;
    }

    public void setMuted(boolean isMuted) {
        this.speechPlayer.setMuted(isMuted);
    }

    public void recordFeedback(String feedbackSource) {
        this.feedbackId = this.navigation.recordFeedback("general", EMPTY_STRING, feedbackSource);
        this.shouldRecordScreenshot.setValue((Object)true);
    }

    public void updateFeedback(FeedbackItem feedbackItem) {
        if (!TextUtils.isEmpty((CharSequence)this.feedbackId)) {
            this.navigation.updateFeedback(this.feedbackId, feedbackItem.getFeedbackType(), feedbackItem.getDescription(), this.screenshot);
            this.sendEventFeedback(feedbackItem);
            this.feedbackId = null;
            this.screenshot = null;
        }
    }

    public void cancelFeedback() {
        if (!TextUtils.isEmpty((CharSequence)this.feedbackId)) {
            this.navigation.cancelFeedback(this.feedbackId);
            this.feedbackId = null;
        }
    }

    @Nullable
    public MapboxNavigation retrieveNavigation() {
        return this.navigation;
    }

    void initializeEventDispatcher(NavigationViewEventDispatcher navigationViewEventDispatcher) {
        this.navigationViewEventDispatcher = navigationViewEventDispatcher;
    }

    void initialize(NavigationViewOptions options) {
        MapboxNavigationOptions navigationOptions = options.navigationOptions();
        navigationOptions = navigationOptions.toBuilder().isFromNavigationUi(true).build();
        this.initializeLanguage(options);
        this.initializeTimeFormat(navigationOptions);
        this.initializeDistanceFormatter(options);
        if (!this.isRunning()) {
            LocationEngine locationEngine = this.initializeLocationEngineFrom(options);
            this.initializeNavigation((Context)this.getApplication(), navigationOptions, locationEngine);
            this.addMilestones(options);
            this.initializeVoiceInstructionLoader();
            this.initializeVoiceInstructionCache();
            this.initializeNavigationSpeechPlayer(options);
            this.initializeMapOfflineManager(options);
        }
        this.router.extractRouteOptions(options);
    }

    void updateFeedbackScreenshot(String screenshot) {
        if (!TextUtils.isEmpty((CharSequence)this.feedbackId)) {
            this.screenshot = screenshot;
        }
        this.shouldRecordScreenshot.setValue((Object)false);
    }

    boolean isRunning() {
        return this.isRunning;
    }

    boolean isMuted() {
        if (this.speechPlayer == null) {
            return false;
        }
        return this.speechPlayer.isMuted();
    }

    void stopNavigation() {
        this.navigation.removeProgressChangeListener(null);
        this.navigation.removeMilestoneEventListener(null);
        this.navigation.stopNavigation();
    }

    boolean isOffRoute() {
        try {
            return (Boolean)this.isOffRoute.getValue();
        }
        catch (NullPointerException exception) {
            return false;
        }
    }

    void updateRoute(DirectionsRoute route) {
        this.route.setValue((Object)route);
        if (!this.isChangingConfigurations) {
            this.startNavigation(route);
            this.updateReplayEngine(route);
            this.sendEventOnRerouteAlong(route);
            this.isOffRoute.setValue((Object)false);
        }
        this.resetConfigurationFlag();
    }

    void updateRouteProgress(RouteProgress routeProgress) {
        this.routeProgress = routeProgress;
        this.sendEventArrival(routeProgress);
        this.instructionModel.setValue((Object)new InstructionModel(this.distanceFormatter, routeProgress));
        this.summaryModel.setValue((Object)new SummaryModel((Context)this.getApplication(), this.distanceFormatter, routeProgress, this.timeFormatType));
    }

    void updateLocation(Location location) {
        this.router.updateLocation(location);
        this.navigationLocation.setValue((Object)location);
    }

    void sendEventFailedReroute(String errorMessage) {
        if (this.navigationViewEventDispatcher != null) {
            this.navigationViewEventDispatcher.onFailedReroute(errorMessage);
        }
    }

    MutableLiveData<Point> retrieveDestination() {
        return this.destination;
    }

    private void initializeRouter() {
        RouteFetcher onlineRouter = new RouteFetcher((Context)this.getApplication(), this.accessToken);
        Context applicationContext = this.getApplication().getApplicationContext();
        ConnectivityStatusProvider connectivityStatus = new ConnectivityStatusProvider(applicationContext);
        this.router = new NavigationViewRouter(onlineRouter, connectivityStatus, this.routeEngineListener);
    }

    private void initializeLocationEngine() {
        this.locationEngineConductor = new LocationEngineConductor();
    }

    private void initializeLanguage(NavigationUiOptions options) {
        RouteOptions routeOptions = options.directionsRoute().routeOptions();
        this.language = this.localeUtils.inferDeviceLanguage((Context)this.getApplication());
        if (routeOptions != null) {
            this.language = routeOptions.language();
        }
    }

    private String initializeUnitType(NavigationUiOptions options) {
        RouteOptions routeOptions = options.directionsRoute().routeOptions();
        String unitType = this.localeUtils.getUnitTypeForDeviceLocale((Context)this.getApplication());
        if (routeOptions != null) {
            unitType = routeOptions.voiceUnits();
        }
        return unitType;
    }

    private void initializeTimeFormat(MapboxNavigationOptions options) {
        this.timeFormatType = options.timeFormatType();
    }

    private int initializeRoundingIncrement(NavigationViewOptions options) {
        MapboxNavigationOptions navigationOptions = options.navigationOptions();
        return navigationOptions.roundingIncrement();
    }

    private void initializeDistanceFormatter(NavigationViewOptions options) {
        String unitType = this.initializeUnitType(options);
        int roundingIncrement = this.initializeRoundingIncrement(options);
        this.distanceFormatter = new DistanceFormatter((Context)this.getApplication(), this.language, unitType, roundingIncrement);
    }

    private void initializeNavigationSpeechPlayer(NavigationViewOptions options) {
        SpeechPlayer speechPlayer = options.speechPlayer();
        if (speechPlayer != null) {
            this.speechPlayer = speechPlayer;
            return;
        }
        boolean isVoiceLanguageSupported = options.directionsRoute().voiceLanguage() != null;
        SpeechPlayerProvider speechPlayerProvider = this.initializeSpeechPlayerProvider(isVoiceLanguageSupported);
        this.speechPlayer = new NavigationSpeechPlayer(speechPlayerProvider);
    }

    private void initializeMapOfflineManager(NavigationViewOptions options) {
        MapOfflineOptions mapOfflineOptions = options.offlineMapOptions();
        if (mapOfflineOptions == null) {
            return;
        }
        String mapDatabasePath = mapOfflineOptions.getDatabasePath();
        String mapStyleUrl = mapOfflineOptions.getStyleUrl();
        Context applicationContext = this.getApplication().getApplicationContext();
        OfflineManager offlineManager = OfflineManager.getInstance((Context)applicationContext);
        float pixelRatio = applicationContext.getResources().getDisplayMetrics().density;
        OfflineRegionDefinitionProvider definitionProvider = new OfflineRegionDefinitionProvider(mapStyleUrl, pixelRatio);
        OfflineMetadataProvider metadataProvider = new OfflineMetadataProvider();
        RegionDownloadCallback regionDownloadCallback = new RegionDownloadCallback(this.connectivityController);
        this.mapOfflineManager = new MapOfflineManager(offlineManager, definitionProvider, metadataProvider, this.connectivityController, regionDownloadCallback);
        NavigationOfflineDatabaseCallback callback = new NavigationOfflineDatabaseCallback(this.navigation, this.mapOfflineManager);
        this.mapOfflineManager.loadDatabase(mapDatabasePath, callback);
    }

    private void initializeVoiceInstructionLoader() {
        Cache cache = new Cache(new File(this.getApplication().getCacheDir(), OKHTTP_INSTRUCTION_CACHE), 0xA00000L);
        this.voiceInstructionLoader = new VoiceInstructionLoader((Context)this.getApplication(), this.accessToken, cache);
    }

    private void initializeVoiceInstructionCache() {
        ConnectivityStatusProvider connectivityStatus = new ConnectivityStatusProvider((Context)this.getApplication());
        this.voiceInstructionCache = new VoiceInstructionCache(this.navigation, this.voiceInstructionLoader, connectivityStatus);
    }

    @NonNull
    private SpeechPlayerProvider initializeSpeechPlayerProvider(boolean voiceLanguageSupported) {
        return new SpeechPlayerProvider((Context)this.getApplication(), this.language, voiceLanguageSupported, this.voiceInstructionLoader);
    }

    private LocationEngine initializeLocationEngineFrom(NavigationViewOptions options) {
        LocationEngine locationEngine = options.locationEngine();
        boolean shouldReplayRoute = options.shouldSimulateRoute();
        this.locationEngineConductor.initializeLocationEngine((Context)this.getApplication(), locationEngine, shouldReplayRoute);
        return this.locationEngineConductor.obtainLocationEngine();
    }

    private void initializeNavigation(Context context, MapboxNavigationOptions options, LocationEngine locationEngine) {
        this.navigation = new MapboxNavigation(context, this.accessToken, options, locationEngine);
        this.addNavigationListeners();
    }

    private void addNavigationListeners() {
        this.navigation.addProgressChangeListener((ProgressChangeListener)new NavigationViewModelProgressChangeListener(this));
        this.navigation.addOffRouteListener(this.offRouteListener);
        this.navigation.addMilestoneEventListener(this.milestoneEventListener);
        this.navigation.addNavigationEventListener(this.navigationEventListener);
        this.navigation.addFasterRouteListener(this.fasterRouteListener);
    }

    private void addMilestones(NavigationViewOptions options) {
        List<Milestone> milestones = options.milestones();
        if (milestones != null && !milestones.isEmpty()) {
            this.navigation.addMilestones(milestones);
        }
    }

    private void startNavigation(DirectionsRoute route) {
        if (route != null) {
            this.navigation.startNavigation(route);
            this.voiceInstructionsToAnnounce = 0;
            this.voiceInstructionCache.preCache(route);
        }
    }

    private void updateReplayEngine(DirectionsRoute route) {
        if (this.locationEngineConductor.updateSimulatedRoute(route)) {
            LocationEngine replayEngine = this.locationEngineConductor.obtainLocationEngine();
            this.navigation.setLocationEngine(replayEngine);
        }
    }

    private void destroyRouter() {
        if (this.router != null) {
            this.router.onDestroy();
        }
    }

    private void endNavigation() {
        if (this.navigation != null) {
            this.navigation.onDestroy();
        }
    }

    private void clearDynamicCameraMap() {
        Camera cameraEngine;
        boolean isDynamicCamera;
        if (this.navigation != null && (isDynamicCamera = (cameraEngine = this.navigation.getCameraEngine()) instanceof DynamicCamera)) {
            ((DynamicCamera)cameraEngine).clearMap();
        }
    }

    private void destroyMapOffline() {
        if (this.mapOfflineManager != null) {
            this.mapOfflineManager.onDestroy();
        }
        this.connectivityController.assign(null);
    }

    private void deactivateInstructionPlayer() {
        if (this.speechPlayer != null) {
            this.speechPlayer.onDestroy();
        }
    }

    private void playVoiceAnnouncement(Milestone milestone) {
        if (milestone instanceof VoiceInstructionMilestone) {
            ++this.voiceInstructionsToAnnounce;
            this.voiceInstructionCache.update(this.voiceInstructionsToAnnounce);
            SpeechAnnouncement announcement = SpeechAnnouncement.builder().voiceInstructionMilestone((VoiceInstructionMilestone)milestone).build();
            announcement = this.retrieveAnnouncementFromSpeechEvent(announcement);
            this.speechPlayer.play(announcement);
        }
    }

    private void updateBannerInstruction(RouteProgress routeProgress, Milestone milestone) {
        if (milestone instanceof BannerInstructionMilestone) {
            BannerInstructions instructions = ((BannerInstructionMilestone)milestone).getBannerInstructions();
            if ((instructions = this.retrieveInstructionsFromBannerEvent(instructions)) != null) {
                BannerInstructionModel model = new BannerInstructionModel(this.distanceFormatter, routeProgress, instructions);
                this.bannerInstructionModel.setValue((Object)model);
            }
        }
    }

    private void sendEventFeedback(FeedbackItem feedbackItem) {
        if (this.navigationViewEventDispatcher != null) {
            this.navigationViewEventDispatcher.onFeedbackSent(feedbackItem);
        }
    }

    private void sendEventArrival(RouteProgress routeProgress) {
        if (this.navigationViewEventDispatcher != null && this.routeUtils.isArrivalEvent(routeProgress)) {
            this.navigationViewEventDispatcher.onArrival();
        }
    }

    private void handleOffRouteEvent(Point newOrigin, float bearing) {
        if (this.navigationViewEventDispatcher != null && this.navigationViewEventDispatcher.allowRerouteFrom(newOrigin, bearing)) {
            this.navigationViewEventDispatcher.onOffRoute(newOrigin);
            this.router.findRouteFrom(this.routeProgress);
            this.isOffRoute.setValue((Object)true);
        }
    }

    private void sendNavigationStatusEvent(boolean isRunning) {
        if (this.navigationViewEventDispatcher != null) {
            if (isRunning) {
                this.navigationViewEventDispatcher.onNavigationRunning();
            } else {
                this.navigationViewEventDispatcher.onNavigationFinished();
            }
        }
    }

    private void sendEventOnRerouteAlong(DirectionsRoute route) {
        if (this.navigationViewEventDispatcher != null && this.isOffRoute()) {
            this.navigationViewEventDispatcher.onRerouteAlong(route);
        }
    }

    private void resetConfigurationFlag() {
        if (this.isChangingConfigurations) {
            this.isChangingConfigurations = false;
        }
    }

    private SpeechAnnouncement retrieveAnnouncementFromSpeechEvent(SpeechAnnouncement announcement) {
        if (this.navigationViewEventDispatcher != null) {
            announcement = this.navigationViewEventDispatcher.onAnnouncement(announcement);
        }
        return announcement;
    }

    private BannerInstructions retrieveInstructionsFromBannerEvent(BannerInstructions instructions) {
        if (this.navigationViewEventDispatcher != null) {
            instructions = this.navigationViewEventDispatcher.onBannerDisplay(instructions);
        }
        return instructions;
    }
}

