/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.NavigationContract;

class NavigationPresenter {
    private NavigationContract.View view;
    private boolean resumeState;

    NavigationPresenter(NavigationContract.View view) {
        this.view = view;
    }

    void updateResumeState(boolean resumeState) {
        this.resumeState = resumeState;
    }

    void onRecenterClick() {
        this.view.setSummaryBehaviorHideable(false);
        this.view.setSummaryBehaviorState(3);
        this.view.updateWayNameVisibility(true);
        this.view.resetCameraPosition();
        this.view.hideRecenterBtn();
    }

    void onCameraTrackingDismissed() {
        if (!this.view.isSummaryBottomSheetHidden()) {
            this.view.setSummaryBehaviorHideable(true);
            this.view.setSummaryBehaviorState(5);
            this.view.updateWayNameVisibility(false);
        }
    }

    void onSummaryBottomSheetHidden() {
        if (this.view.isSummaryBottomSheetHidden()) {
            this.view.showRecenterBtn();
        }
    }

    void onRouteUpdate(DirectionsRoute directionsRoute) {
        this.view.drawRoute(directionsRoute);
        if (this.resumeState && this.view.isRecenterButtonVisible()) {
            this.view.updateCameraRouteOverview();
        } else {
            this.view.startCamera(directionsRoute);
        }
    }

    void onDestinationUpdate(Point point) {
        this.view.addMarker(point);
    }

    void onShouldRecordScreenshot() {
        this.view.takeScreenshot();
    }

    void onNavigationLocationUpdate(Location location) {
        if (this.resumeState && !this.view.isRecenterButtonVisible()) {
            this.view.resumeCamera(location);
            this.resumeState = false;
        }
        this.view.updateNavigationMap(location);
    }

    void onWayNameChanged(@NonNull String wayName) {
        if (TextUtils.isEmpty((CharSequence)wayName) || this.view.isSummaryBottomSheetHidden()) {
            this.view.updateWayNameVisibility(false);
            return;
        }
        this.view.updateWayNameView(wayName);
        this.view.updateWayNameVisibility(true);
    }

    void onNavigationStopped() {
        this.view.updateWayNameVisibility(false);
    }

    void onRouteOverviewClick() {
        this.view.updateWayNameVisibility(false);
        this.view.updateCameraRouteOverview();
        this.view.showRecenterBtn();
    }
}

