/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.offline.OfflineGeometryRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.services.android.navigation.ui.v5.CreateOfflineRegionCallback;
import com.mapbox.services.android.navigation.ui.v5.MapConnectivityController;
import com.mapbox.services.android.navigation.ui.v5.MergeOfflineRegionsCallback;
import com.mapbox.services.android.navigation.ui.v5.OfflineDatabaseLoadedCallback;
import com.mapbox.services.android.navigation.ui.v5.OfflineMetadataProvider;
import com.mapbox.services.android.navigation.ui.v5.OfflineRegionDefinitionProvider;
import com.mapbox.services.android.navigation.ui.v5.OfflineRegionDownloadCallback;
import com.mapbox.services.android.navigation.ui.v5.RegionDownloadCallback;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

class MapOfflineManager
implements ProgressChangeListener {
    private final OfflineManager offlineManager;
    private final OfflineRegionDefinitionProvider definitionProvider;
    private final OfflineMetadataProvider metadataProvider;
    private final MapConnectivityController connectivityController;
    private final RegionDownloadCallback regionDownloadCallback;
    private Geometry previousRouteGeometry;
    private MergeOfflineRegionsCallback mergeOfflineRegionsCallback;

    MapOfflineManager(OfflineManager offlineManager, OfflineRegionDefinitionProvider definitionProvider, OfflineMetadataProvider metadataProvider, MapConnectivityController connectivityController, RegionDownloadCallback regionDownloadCallback) {
        this.offlineManager = offlineManager;
        this.definitionProvider = definitionProvider;
        this.metadataProvider = metadataProvider;
        this.connectivityController = connectivityController;
        this.regionDownloadCallback = regionDownloadCallback;
    }

    MapOfflineManager(OfflineManager offlineManager, OfflineRegionDefinitionProvider definitionProvider, OfflineMetadataProvider metadataProvider, MapConnectivityController connectivityController, RegionDownloadCallback regionDownloadCallback, MergeOfflineRegionsCallback mergeOfflineRegionsCallback) {
        this.offlineManager = offlineManager;
        this.definitionProvider = definitionProvider;
        this.metadataProvider = metadataProvider;
        this.connectivityController = connectivityController;
        this.regionDownloadCallback = regionDownloadCallback;
        this.mergeOfflineRegionsCallback = mergeOfflineRegionsCallback;
    }

    public void onProgressChange(Location location, RouteProgress routeProgress) {
        Geometry currentRouteGeometry = routeProgress.routeGeometryWithBuffer();
        if (this.previousRouteGeometry == null || !this.previousRouteGeometry.equals(currentRouteGeometry)) {
            this.previousRouteGeometry = currentRouteGeometry;
            String routeSummary = routeProgress.directionsRoute().routeOptions().requestUuid();
            this.download(routeSummary, this.previousRouteGeometry, this.regionDownloadCallback);
        }
    }

    void loadDatabase(@NonNull String offlineDatabasePath, OfflineDatabaseLoadedCallback callback) {
        this.mergeOfflineRegionsCallback = new MergeOfflineRegionsCallback(callback);
        this.offlineManager.mergeOfflineRegions(offlineDatabasePath, (OfflineManager.MergeOfflineRegionsCallback)this.mergeOfflineRegionsCallback);
    }

    void onDestroy() {
        if (this.mergeOfflineRegionsCallback != null) {
            this.mergeOfflineRegionsCallback.onDestroy();
        }
    }

    private void download(@NonNull String routeSummary, @NonNull Geometry routeGeometry, OfflineRegionDownloadCallback callback) {
        OfflineGeometryRegionDefinition definition = this.definitionProvider.buildRegionFor(routeGeometry);
        byte[] metadata = this.metadataProvider.buildMetadataFor(routeSummary);
        this.connectivityController.assign(null);
        this.offlineManager.createOfflineRegion((OfflineRegionDefinition)definition, metadata, (OfflineManager.CreateOfflineRegionCallback)new CreateOfflineRegionCallback(callback));
    }
}

