/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import java.util.HashMap;

class DamerauLevenshteinAlgorithm {
    private static final int DELETE_COST = 1;
    private static final int INSERT_COST = 1;
    private static final int REPLACE_COST = 1;
    private static final int SWAP_COST = 1;

    DamerauLevenshteinAlgorithm() {
    }

    static int execute(String source, String target) {
        int matchDistance;
        int insertDistance;
        int deleteDistance;
        int i;
        if (source.length() == 0) {
            return target.length() * 1;
        }
        if (target.length() == 0) {
            return source.length() * 1;
        }
        int[][] table = new int[source.length()][target.length()];
        HashMap<Character, Integer> sourceIndexByCharacter = new HashMap<Character, Integer>();
        if (source.charAt(0) != target.charAt(0)) {
            table[0][0] = Math.min(1, 2);
        }
        sourceIndexByCharacter.put(Character.valueOf(source.charAt(0)), 0);
        for (i = 1; i < source.length(); ++i) {
            deleteDistance = table[i - 1][0] + 1;
            insertDistance = (i + 1) * 1 + 1;
            matchDistance = i * 1 + (source.charAt(i) == target.charAt(0) ? 0 : 1);
            table[i][0] = Math.min(Math.min(deleteDistance, insertDistance), matchDistance);
        }
        for (int j = 1; j < target.length(); ++j) {
            deleteDistance = (j + 1) * 1 + 1;
            insertDistance = table[0][j - 1] + 1;
            matchDistance = j * 1 + (source.charAt(0) == target.charAt(j) ? 0 : 1);
            table[0][j] = Math.min(Math.min(deleteDistance, insertDistance), matchDistance);
        }
        for (i = 1; i < source.length(); ++i) {
            int maxSourceLetterMatchIndex = source.charAt(i) == target.charAt(0) ? 0 : -1;
            for (int j = 1; j < target.length(); ++j) {
                int swapDistance;
                Integer candidateSwapIndex = (Integer)sourceIndexByCharacter.get(Character.valueOf(target.charAt(j)));
                int indexJSwap = maxSourceLetterMatchIndex;
                int deleteDistance2 = table[i - 1][j] + 1;
                int insertDistance2 = table[i][j - 1] + 1;
                int matchDistance2 = table[i - 1][j - 1];
                if (source.charAt(i) != target.charAt(j)) {
                    ++matchDistance2;
                } else {
                    maxSourceLetterMatchIndex = j;
                }
                if (candidateSwapIndex != null && indexJSwap != -1) {
                    int indexISwap = candidateSwapIndex;
                    int preSwapCost = indexISwap == 0 && indexJSwap == 0 ? 0 : table[Math.max(0, indexISwap - 1)][Math.max(0, indexJSwap - 1)];
                    swapDistance = preSwapCost + (i - indexISwap - 1) * 1 + (j - indexJSwap - 1) * 1 + 1;
                } else {
                    swapDistance = Integer.MAX_VALUE;
                }
                table[i][j] = Math.min(Math.min(Math.min(deleteDistance2, insertDistance2), matchDistance2), swapDistance);
            }
            sourceIndexByCharacter.put(Character.valueOf(source.charAt(i)), i);
        }
        return table[source.length() - 1][target.length() - 1];
    }
}

