/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerUtils;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.StubMappingStore;
import com.github.tomakehurst.wiremock.store.files.BlobStoreFileSource;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class AbstractStubMappings
implements StubMappings {
    protected final StubMappingStore store;
    protected final Scenarios scenarios;
    protected final Map<String, RequestMatcherExtension> customMatchers;
    protected final Map<String, ResponseDefinitionTransformer> transformers;
    protected final Map<String, ResponseDefinitionTransformerV2> v2transformers;
    protected final FileSource filesFileSource;
    protected final List<StubLifecycleListener> stubLifecycleListeners;
    protected final Map<String, ServeEventListener> serveEventListeners;

    public AbstractStubMappings(StubMappingStore store, Scenarios scenarios, Map<String, RequestMatcherExtension> customMatchers, Map<String, ResponseDefinitionTransformer> transformers, Map<String, ResponseDefinitionTransformerV2> v2transformers, BlobStore filesBlobStore, List<StubLifecycleListener> stubLifecycleListeners, Map<String, ServeEventListener> serveEventListeners) {
        this.store = store;
        this.scenarios = scenarios;
        this.customMatchers = customMatchers;
        this.transformers = transformers;
        this.v2transformers = v2transformers;
        this.filesFileSource = new BlobStoreFileSource(filesBlobStore);
        this.stubLifecycleListeners = stubLifecycleListeners;
        this.serveEventListeners = serveEventListeners;
    }

    @Override
    public ServeEvent serveFor(ServeEvent initialServeEvent) {
        LoggedRequest request = initialServeEvent.getRequest();
        LinkedList subEvents = new LinkedList();
        StubMapping matchingStub = this.store.findAllMatchingRequest(request, this.customMatchers, subEvents::add).filter(stubMapping -> stubMapping.isIndependentOfScenarioState() || this.scenarios.mappingMatchesScenarioState((StubMapping)stubMapping)).findFirst().orElse(StubMapping.NOT_CONFIGURED);
        subEvents.forEach(initialServeEvent::appendSubEvent);
        this.scenarios.onStubServed(matchingStub);
        ResponseDefinition initialResponseDefinition = matchingStub.getResponse();
        ServeEvent serveEvent = initialServeEvent.withStubMapping(matchingStub).withResponseDefinition(initialResponseDefinition);
        ServeEventListenerUtils.triggerListeners(this.serveEventListeners, ServeEventListener.RequestPhase.AFTER_MATCH, serveEvent);
        ResponseDefinition responseDefinition = this.applyV1Transformations(request, matchingStub.getResponse(), List.copyOf(this.transformers.values()));
        serveEvent = serveEvent.withResponseDefinition(responseDefinition);
        Pair<ServeEvent, ResponseDefinition> transformed = this.applyV2Transformations(serveEvent, List.copyOf(this.v2transformers.values()));
        serveEvent = (ServeEvent)transformed.a;
        responseDefinition = (ResponseDefinition)transformed.b;
        return serveEvent.withResponseDefinition(ResponseDefinition.copyOf(responseDefinition));
    }

    private ResponseDefinition applyV1Transformations(Request request, ResponseDefinition responseDefinition, List<ResponseDefinitionTransformer> transformers) {
        if (transformers.isEmpty()) {
            return responseDefinition;
        }
        ResponseDefinitionTransformer transformer = transformers.get(0);
        ResponseDefinition newResponseDef = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request, responseDefinition, this.filesFileSource, ParameterUtils.getFirstNonNull(responseDefinition.getTransformerParameters(), Parameters.empty())) : responseDefinition;
        return this.applyV1Transformations(request, newResponseDef, transformers.subList(1, transformers.size()));
    }

    private Pair<ServeEvent, ResponseDefinition> applyV2Transformations(ServeEvent serveEvent, List<ResponseDefinitionTransformerV2> transformers) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        if (transformers.isEmpty()) {
            return Pair.pair(serveEvent, responseDefinition);
        }
        ResponseDefinitionTransformerV2 transformer = transformers.get(0);
        ResponseDefinition newResponseDef = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(serveEvent) : responseDefinition;
        return this.applyV2Transformations(serveEvent.withResponseDefinition(newResponseDef), transformers.subList(1, transformers.size()));
    }

    @Override
    public void addMapping(StubMapping mapping) {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubCreated(mapping);
        }
        this.store.add(mapping);
        this.scenarios.onStubMappingAdded(mapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubCreated(mapping);
        }
    }

    @Override
    public void removeMapping(StubMapping mapping) {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubRemoved(mapping);
        }
        this.store.remove(mapping);
        this.scenarios.onStubMappingRemoved(mapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubRemoved(mapping);
        }
    }

    @Override
    public void editMapping(StubMapping stubMapping) {
        Optional<StubMapping> optionalExistingMapping = this.store.get(stubMapping.getId());
        if (optionalExistingMapping.isEmpty()) {
            String msg = "StubMapping with UUID: " + stubMapping.getUuid() + " not found";
            LocalNotifier.notifier().error(msg);
            throw new NotFoundException(msg);
        }
        StubMapping existingMapping = optionalExistingMapping.get();
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubEdited(existingMapping, stubMapping);
        }
        stubMapping.setInsertionIndex(existingMapping.getInsertionIndex());
        stubMapping.setDirty(true);
        this.store.replace(existingMapping, stubMapping);
        this.scenarios.onStubMappingUpdated(existingMapping, stubMapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubEdited(existingMapping, stubMapping);
        }
    }

    @Override
    public void reset() {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubsReset();
        }
        this.store.clear();
        this.scenarios.clear();
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubsReset();
        }
    }

    @Override
    public void resetScenarios() {
        this.scenarios.reset();
    }

    @Override
    public List<StubMapping> getAll() {
        return this.store.getAll().collect(Collectors.toList());
    }

    @Override
    public Optional<StubMapping> get(UUID id) {
        return this.store.get(id);
    }

    @Override
    public List<Scenario> getAllScenarios() {
        return this.scenarios.getAll();
    }

    @Override
    public List<StubMapping> findByMetadata(StringValuePattern pattern) {
        return this.store.getAll().filter(stubMapping -> {
            String metadataJson = Json.write(stubMapping.getMetadata());
            return pattern.match(metadataJson).isExactMatch();
        }).collect(Collectors.toList());
    }
}

