/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Json;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class JsonData<T> {
    protected final T data;

    protected abstract String toJsonString();

    public String toString() {
        return this.toJsonString();
    }

    static Object create(Object data) {
        if (data instanceof Map) {
            return new MapJsonData((Map)data);
        }
        if (data instanceof List) {
            return new ListJsonData((List)data);
        }
        return data;
    }

    public JsonData(T data) {
        this.data = data;
    }

    public static class ListJsonData
    extends JsonData<List<Object>>
    implements List<Object> {
        public ListJsonData(List<Object> data) {
            super(data);
        }

        @Override
        public int size() {
            return ((List)this.data).size();
        }

        @Override
        public boolean isEmpty() {
            return ((List)this.data).isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ((List)this.data).contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return ((List)this.data).iterator();
        }

        @Override
        public Object[] toArray() {
            return ((List)this.data).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ((List)this.data).toArray(a);
        }

        @Override
        public boolean add(Object o) {
            return ((List)this.data).add(o);
        }

        @Override
        public boolean remove(Object o) {
            return ((List)this.data).remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ((List)this.data).containsAll(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            return ((List)this.data).addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            return ((List)this.data).addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return ((List)this.data).removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return ((List)this.data).retainAll(c);
        }

        @Override
        public void clear() {
            ((List)this.data).clear();
        }

        @Override
        public boolean equals(Object o) {
            return ((List)this.data).equals(o);
        }

        @Override
        public int hashCode() {
            return ((List)this.data).hashCode();
        }

        @Override
        public Object get(int index) {
            return ((List)this.data).get(index);
        }

        @Override
        public Object set(int index, Object element) {
            return ((List)this.data).set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            ((List)this.data).add(index, element);
        }

        @Override
        public Object remove(int index) {
            return ((List)this.data).remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.data).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.data).lastIndexOf(o);
        }

        @Override
        public ListIterator<Object> listIterator() {
            return ((List)this.data).listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return ((List)this.data).listIterator(index);
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return ((List)this.data).subList(fromIndex, toIndex);
        }

        @Override
        protected String toJsonString() {
            return String.valueOf(this.data);
        }
    }

    public static class MapJsonData
    extends JsonData<Map<String, Object>>
    implements Map<String, Object> {
        @Override
        protected String toJsonString() {
            return Json.write(this.data);
        }

        public MapJsonData(Map<String, Object> data) {
            super(data);
        }

        @Override
        public int size() {
            return ((Map)this.data).size();
        }

        @Override
        public boolean isEmpty() {
            return ((Map)this.data).isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return ((Map)this.data).containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return ((Map)this.data).containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return ((Map)this.data).get(key);
        }

        @Override
        public Object remove(Object key) {
            return ((Map)this.data).remove(key);
        }

        @Override
        public void clear() {
            ((Map)this.data).clear();
        }

        @Override
        public Set<String> keySet() {
            return ((Map)this.data).keySet();
        }

        @Override
        public Collection<Object> values() {
            return ((Map)this.data).values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return ((Map)this.data).entrySet();
        }

        @Override
        public void putAll(Map<? extends String, ?> m3) {
            ((Map)this.data).putAll(m3);
        }

        @Override
        public Object put(String key, Object value) {
            return ((Map)this.data).put(key, value);
        }
    }
}

