/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import wiremock.org.apache.hc.client5.http.HttpRoute;
import wiremock.org.apache.hc.client5.http.UserTokenHandler;
import wiremock.org.apache.hc.client5.http.auth.AuthExchange;
import wiremock.org.apache.hc.client5.http.auth.AuthScheme;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpRoute route, HttpContext context) {
        SSLSession sslSession;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthExchange targetAuthExchange = clientContext.getAuthExchange(route.getTargetHost());
        if (targetAuthExchange != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthExchange)) == null && route.getProxyHost() != null) {
            AuthExchange proxyAuthExchange = clientContext.getAuthExchange(route.getProxyHost());
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthExchange);
        }
        if (userPrincipal == null && (sslSession = clientContext.getSSLSession()) != null) {
            userPrincipal = sslSession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthExchange authExchange) {
        AuthScheme scheme = authExchange.getAuthScheme();
        if (scheme != null && scheme.isConnectionBased()) {
            return scheme.getPrincipal();
        }
        return null;
    }
}

