/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.io.ByteStreams;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class WireMockHttpServletMultipartAdapter
implements Request.Part {
    private final Part mPart;
    private final HttpHeaders headers;

    public WireMockHttpServletMultipartAdapter(final Part servletPart) {
        this.mPart = servletPart;
        FluentIterable httpHeaders = FluentIterable.from((Iterable)this.mPart.getHeaderNames()).transform((Function)new Function<String, HttpHeader>(){

            public HttpHeader apply(String name) {
                Collection headerValues = servletPart.getHeaders(name);
                return HttpHeader.httpHeader(name, headerValues.toArray(new String[headerValues.size()]));
            }
        });
        this.headers = new HttpHeaders((Iterable<HttpHeader>)httpHeaders);
    }

    public static WireMockHttpServletMultipartAdapter from(Part servletPart) {
        return new WireMockHttpServletMultipartAdapter(servletPart);
    }

    @Override
    public String getName() {
        return this.mPart.getName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public Body getBody() {
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)this.mPart.getInputStream());
            HttpHeader header = this.getHeader("Content-Type");
            ContentTypeHeader contentTypeHeader = header.isPresent() ? new ContentTypeHeader(header.firstValue()) : ContentTypeHeader.absent();
            return Body.ofBinaryOrText(bytes, contentTypeHeader);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Body.class);
        }
    }
}

