/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty.DefaultMultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.jetty.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty11.ManInTheMiddleSslConnectHandler;
import com.github.tomakehurst.wiremock.jetty11.SslContexts;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class Jetty11HttpServer
extends JettyHttpServer {
    private ServerConnector mitmProxyConnector;

    public Jetty11HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        super(options, adminRequestHandler, stubRequestHandler);
    }

    @Override
    protected MultipartRequestConfigurer buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigurer();
    }

    @Override
    protected HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = super.createHttpConfig(jettySettings);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setSendServerVersion(false);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(false));
        return httpConfig;
    }

    @Override
    protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        HTTP2CServerConnectionFactory h2c = new HTTP2CServerConnectionFactory(httpConfig);
        return this.createServerConnector(bindAddress, jettySettings, port, listener, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig), h2c});
    }

    @Override
    protected ServerConnector createHttpsConnector(Server server, String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        ConnectionFactory[] connectionFactories;
        SslContextFactory.Server http2SslContextFactory = SslContexts.buildHttp2SslContextFactory(httpsSettings);
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
        try {
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, alpn.getProtocol());
            connectionFactories = new ConnectionFactory[]{ssl, alpn, h2, http};
        }
        catch (IllegalStateException e) {
            SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, http.getProtocol());
            connectionFactories = new ConnectionFactory[]{ssl, http};
        }
        return this.createServerConnector(bindAddress, jettySettings, httpsSettings.port(), listener, connectionFactories);
    }

    @Override
    protected HandlerCollection createHandler(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        HandlerCollection handler = super.createHandler(options, adminRequestHandler, stubRequestHandler);
        if (options.browserProxySettings().enabled()) {
            handler.prependHandler((Handler)new ManInTheMiddleSslConnectHandler(this.mitmProxyConnector));
        }
        return handler;
    }

    @Override
    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
        if (options.browserProxySettings().enabled()) {
            SslConnectionFactory ssl = new SslConnectionFactory(SslContexts.buildManInTheMiddleSslContextFactory(options.httpsSettings(), options.browserProxySettings(), options.notifier()), HttpVersion.HTTP_1_1.asString());
            JettySettings jettySettings = options.jettySettings();
            HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            this.mitmProxyConnector = new NetworkTrafficServerConnector(jettyServer, null, null, null, 2, 2, new ConnectionFactory[]{ssl, http});
            this.mitmProxyConnector.setPort(0);
            this.mitmProxyConnector.setShutdownIdleTimeout(((Long)jettySettings.getShutdownIdleTimeout().or((Object)100L)).longValue());
            jettyServer.addConnector((Connector)this.mitmProxyConnector);
        }
    }
}

