/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultipleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.List;

@JsonDeserialize(as=ExactMatchMultiValuePattern.class)
public class ExactMatchMultiValuePattern
extends MultipleMatchMultiValuePattern {
    public static final String JSON_KEY = "hasExactly";
    public static final String HAS_EXACTLY_OPERATOR = " exactly ";
    @JsonProperty(value="hasExactly")
    private List<StringValuePattern> stringValuePatterns;

    @JsonCreator
    public ExactMatchMultiValuePattern(@JsonProperty(value="hasExactly") List<StringValuePattern> valuePatterns) {
        this.stringValuePatterns = valuePatterns;
    }

    @Override
    public MatchResult match(MultiValue value) {
        if (!value.isPresent()) {
            return MatchResult.of(false);
        }
        return MatchResult.aggregate(MatchResult.of(this.stringValuePatterns.size() == value.values().size()), super.match(value));
    }

    @Override
    public List<StringValuePattern> getValues() {
        return this.stringValuePatterns;
    }

    @Override
    public String getOperator() {
        return HAS_EXACTLY_OPERATOR;
    }
}

