/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<Object> {
    public Object apply(Object input, Options options) throws IOException {
        if (input == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPath = (String)options.param(0);
        try {
            Object result = input instanceof String ? JsonPath.read((String)((String)input), (String)jsonPath, (Predicate[])new Predicate[0]) : JsonPath.read((Object)input, (String)jsonPath, (Predicate[])new Predicate[0]);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(input + " is not valid JSON", e.getJson(), e);
        }
        catch (JsonPathException e) {
            return this.handleError(jsonPath + " is not a valid JSONPath expression", e);
        }
    }
}

