/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.FaultInjectingHttpConnectionFactory;
import com.github.tomakehurst.wiremock.jetty9.JettyHandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class JettyHttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final Server jettyServer;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;

    JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler, RequestDelayControl requestDelayControl) {
        QueuedThreadPool threadPool = new QueuedThreadPool(options.containerThreads());
        this.jettyServer = new Server((ThreadPool)threadPool);
        this.httpConnector = this.createHttpConnector(requestDelayControl, options.bindAddress(), options.portNumber(), options.jettySettings());
        this.jettyServer.addConnector((Connector)this.httpConnector);
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(requestDelayControl, options.httpsSettings(), options.jettySettings());
            this.jettyServer.addConnector((Connector)this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(stubRequestHandler, options.filesRoot(), notifier);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{adminContext, mockServiceContext});
        this.jettyServer.setHandler((Handler)handlers);
        this.jettyServer.setStopTimeout(0L);
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    private ServerConnector createHttpConnector(RequestDelayControl requestDelayControl, String bindAddress, int port, JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        this.setHeaderBufferSize(jettySettings, httpConfig);
        ServerConnector connector = this.createServerConnector(jettySettings, port, new ConnectionFactory[]{new FaultInjectingHttpConnectionFactory(httpConfig, requestDelayControl)});
        connector.setHost(bindAddress);
        return connector;
    }

    private ServerConnector createHttpsConnector(RequestDelayControl requestDelayControl, HttpsSettings httpsSettings, JettySettings jettySettings) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(httpsSettings.keyStorePath());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyStorePassword());
        if (httpsSettings.hasTrustStore()) {
            sslContextFactory.setTrustStorePath(httpsSettings.trustStorePath());
            sslContextFactory.setTrustStorePassword(httpsSettings.trustStorePassword());
        }
        sslContextFactory.setNeedClientAuth(httpsSettings.needClientAuth());
        HttpConfiguration httpConfig = new HttpConfiguration();
        this.setHeaderBufferSize(jettySettings, httpConfig);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        int port = httpsSettings.port();
        return this.createServerConnector(jettySettings, port, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new FaultInjectingHttpConnectionFactory(httpConfig, requestDelayControl)});
    }

    private ServerConnector createServerConnector(JettySettings jettySettings, int port, ConnectionFactory ... connectionFactories) {
        int acceptors = (Integer)jettySettings.getAcceptors().or((Object)2);
        ServerConnector connector = new ServerConnector(this.jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.setStopTimeout(0L);
        connector.getSelectorManager().setStopTimeout(0L);
        this.setJettySettings(jettySettings, connector);
        return connector;
    }

    private void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(((Integer)jettySettings.getAcceptQueueSize().get()).intValue());
        }
    }

    private void setHeaderBufferSize(JettySettings jettySettings, HttpConfiguration configuration) {
        int headerBufferSize = 8192;
        if (jettySettings.getRequestHeaderSize().isPresent()) {
            headerBufferSize = (Integer)jettySettings.getRequestHeaderSize().get();
        }
        configuration.setRequestHeaderSize(headerBufferSize);
    }

    private ServletContextHandler addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler((HandlerContainer)this.jettyServer, "/");
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(JettyHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(GzipFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler((HandlerContainer)this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(JettyHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)notifier);
        return adminContext;
    }
}

