/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.SortedConcurrentMappingSet;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryStubMappings
implements StubMappings {
    private final SortedConcurrentMappingSet mappings = new SortedConcurrentMappingSet();
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();
    private final Map<String, RequestMatcherExtension> customMatchers;

    public InMemoryStubMappings(Map<String, RequestMatcherExtension> customMatchers) {
        this.customMatchers = customMatchers;
    }

    public InMemoryStubMappings() {
        this(Collections.emptyMap());
    }

    @Override
    public ResponseDefinition serveFor(Request request) {
        StubMapping matchingMapping = (StubMapping)Iterables.find((Iterable)this.mappings, this.mappingMatchingAndInCorrectScenarioState(request), (Object)StubMapping.NOT_CONFIGURED);
        this.notifyIfResponseNotConfigured(request, matchingMapping);
        matchingMapping.updateScenarioStateIfRequired();
        return ResponseDefinition.copyOf(matchingMapping.getResponse());
    }

    private void notifyIfResponseNotConfigured(Request request, StubMapping matchingMapping) {
        if (matchingMapping == StubMapping.NOT_CONFIGURED) {
            LocalNotifier.notifier().info("No mapping found matching URL " + request.getUrl());
        }
    }

    @Override
    public void addMapping(StubMapping mapping) {
        if (mapping.isInScenario()) {
            this.scenarioMap.putIfAbsent(mapping.getScenarioName(), Scenario.inStartedState());
            Scenario scenario = this.scenarioMap.get(mapping.getScenarioName());
            mapping.setScenario(scenario);
        }
        this.mappings.add(mapping);
    }

    @Override
    public void reset() {
        this.mappings.clear();
        this.scenarioMap.clear();
    }

    @Override
    public void resetScenarios() {
        for (Scenario scenario : this.scenarioMap.values()) {
            scenario.reset();
        }
    }

    @Override
    public List<StubMapping> getAll() {
        return ImmutableList.copyOf((Iterable)this.mappings);
    }

    private Predicate<StubMapping> mappingMatchingAndInCorrectScenarioState(final Request request) {
        return new Predicate<StubMapping>(){

            public boolean apply(StubMapping mapping) {
                return mapping.getRequest().isMatchedBy(request, InMemoryStubMappings.this.customMatchers) && (mapping.isIndependentOfScenarioState() || mapping.requiresCurrentScenarioState());
            }
        };
    }
}

