/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Response {
    private final int status;
    private final byte[] body;
    private final HttpHeaders headers;
    private final boolean configured;
    private final Fault fault;
    private final boolean fromProxy;
    private final Optional<ResponseDefinition> renderedFromDefinition;

    public static Response notConfigured() {
        Response response = new Response(404, (byte[])null, HttpHeaders.noHeaders(), false, null, false, (Optional<ResponseDefinition>)Optional.absent());
        return response;
    }

    public static Builder response() {
        return new Builder();
    }

    public Response(int status, byte[] body, HttpHeaders headers, boolean configured, Fault fault, boolean fromProxy, Optional<ResponseDefinition> renderedFromDefinition) {
        this.status = status;
        this.body = body;
        this.headers = headers;
        this.configured = configured;
        this.fault = fault;
        this.fromProxy = fromProxy;
        this.renderedFromDefinition = renderedFromDefinition;
    }

    public Response(int status, String body, HttpHeaders headers, boolean configured, Fault fault, boolean fromProxy, Optional<ResponseDefinition> renderedFromDefinition) {
        this.status = status;
        this.headers = headers;
        this.renderedFromDefinition = renderedFromDefinition;
        this.body = body == null ? null : body.getBytes(this.encodingFromContentTypeHeaderOrUtf8());
        this.configured = configured;
        this.fault = fault;
        this.fromProxy = fromProxy;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return new String(this.body, this.encodingFromContentTypeHeaderOrUtf8());
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Fault getFault() {
        return this.fault;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.headers.getContentTypeHeader();
        if (contentTypeHeader.isPresent() && contentTypeHeader.encodingPart().isPresent()) {
            return Charset.forName((String)contentTypeHeader.encodingPart().get());
        }
        return Charsets.UTF_8;
    }

    public boolean wasConfigured() {
        return this.configured;
    }

    public boolean isFromProxy() {
        return this.fromProxy;
    }

    public String toString() {
        return "Response [status=" + this.status + ", body=" + Arrays.toString(this.body) + ", headers=" + this.headers + ", configured=" + this.configured + ", fault=" + (Object)((Object)this.fault) + ", fromProxy=" + this.fromProxy + "]";
    }

    public static class Builder {
        private int status = 200;
        private byte[] body;
        private String bodyString;
        private HttpHeaders headers = new HttpHeaders();
        private boolean configured = true;
        private Fault fault;
        private boolean fromProxy;
        private Optional<ResponseDefinition> renderedFromDefinition;

        public static Builder like(Response response) {
            Builder responseBuilder = new Builder();
            responseBuilder.status = response.getStatus();
            responseBuilder.body = response.getBody();
            responseBuilder.headers = response.getHeaders();
            responseBuilder.configured = response.wasConfigured();
            responseBuilder.fault = response.getFault();
            responseBuilder.fromProxy = response.isFromProxy();
            return responseBuilder;
        }

        public Builder but() {
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            this.bodyString = null;
            this.ensureOnlyOneBodySet();
            return this;
        }

        public Builder body(String body) {
            this.bodyString = body;
            this.body = null;
            this.ensureOnlyOneBodySet();
            return this;
        }

        private void ensureOnlyOneBodySet() {
            if (this.body != null && this.bodyString != null) {
                throw new IllegalStateException("Body should either be set as a String or byte[], not both");
            }
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers == null ? HttpHeaders.noHeaders() : headers;
            return this;
        }

        public Builder configured(boolean configured) {
            this.configured = configured;
            return this;
        }

        public Builder fault(Fault fault) {
            this.fault = fault;
            return this;
        }

        public Builder fromProxy(boolean fromProxy) {
            this.fromProxy = fromProxy;
            return this;
        }

        public Builder renderedFromDefinition(ResponseDefinition renderedFromDefinition) {
            this.renderedFromDefinition = Optional.fromNullable((Object)renderedFromDefinition);
            return this;
        }

        public Response build() {
            if (this.body != null) {
                return new Response(this.status, this.body, this.headers, this.configured, this.fault, this.fromProxy, this.renderedFromDefinition);
            }
            if (this.bodyString != null) {
                return new Response(this.status, this.bodyString, this.headers, this.configured, this.fault, this.fromProxy, this.renderedFromDefinition);
            }
            return new Response(this.status, new byte[0], this.headers, this.configured, this.fault, this.fromProxy, this.renderedFromDefinition);
        }
    }
}

