/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.servlet.HttpServletRequestAdapter;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HandlerDispatchingServlet
extends HttpServlet {
    public static final String SHOULD_FORWARD_TO_FILES_CONTEXT = "shouldForwardToFilesContext";
    public static final String MAPPED_UNDER_KEY = "mappedUnder";
    private static final long serialVersionUID = -6602042274260495538L;
    private RequestHandler requestHandler;
    private String mappedUnder;
    private Notifier notifier;
    private String wiremockFileSourceRoot = "/";
    private boolean shouldForwardToFilesContext;

    public void init(ServletConfig config) {
        ServletContext context = config.getServletContext();
        this.shouldForwardToFilesContext = this.getFileContextForwardingFlagFrom(config);
        if (context.getInitParameter("WireMockFileSourceRoot") != null) {
            this.wiremockFileSourceRoot = context.getInitParameter("WireMockFileSourceRoot");
        }
        String handlerClassName = config.getInitParameter("RequestHandlerClass");
        this.mappedUnder = this.getNormalizedMappedUnder(config);
        context.log("RequestHandlerClass from context returned " + handlerClassName + ". Normlized mapped under returned '" + this.mappedUnder + "'");
        this.requestHandler = (RequestHandler)context.getAttribute(handlerClassName);
        this.notifier = (Notifier)context.getAttribute("Notifier");
    }

    private String getNormalizedMappedUnder(ServletConfig config) {
        String mappedUnder = config.getInitParameter(MAPPED_UNDER_KEY);
        if (mappedUnder == null) {
            return null;
        }
        if (mappedUnder.endsWith("/")) {
            mappedUnder = mappedUnder.substring(0, mappedUnder.length() - 1);
        }
        return mappedUnder;
    }

    private boolean getFileContextForwardingFlagFrom(ServletConfig config) {
        String flagValue = config.getInitParameter(SHOULD_FORWARD_TO_FILES_CONTEXT);
        return Boolean.valueOf(flagValue);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        LocalNotifier.set(this.notifier);
        HttpServletRequestAdapter request = new HttpServletRequestAdapter(httpServletRequest, this.mappedUnder);
        this.notifier.info("Received request: " + httpServletRequest.toString());
        Response response = this.requestHandler.handle(request);
        if (response.wasConfigured()) {
            response.applyTo(httpServletResponse);
        } else if (request.getMethod() == RequestMethod.GET && this.shouldForwardToFilesContext) {
            this.forwardToFilesContext(httpServletRequest, httpServletResponse, request);
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void forwardToFilesContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Request request) throws ServletException, IOException {
        String forwardUrl = this.wiremockFileSourceRoot + "__files" + request.getUrl();
        RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(URLDecoder.decode(forwardUrl, Charsets.UTF_8.name()));
        dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

