/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.HttpAdminClient;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;

public class WireMock {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private Admin admin;
    private static WireMock defaultInstance = new WireMock();

    public WireMock(String host, int port) {
        this.admin = new HttpAdminClient(host, port);
    }

    public WireMock(String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(host, port, urlPathPrefix);
    }

    public WireMock() {
        this.admin = new HttpAdminClient(DEFAULT_HOST, 8080);
    }

    void setAdmin(Admin admin) {
        this.admin = admin;
    }

    public static void givenThat(MappingBuilder mappingBuilder) {
        defaultInstance.register(mappingBuilder);
    }

    public static void stubFor(MappingBuilder mappingBuilder) {
        WireMock.givenThat(mappingBuilder);
    }

    public static void configureFor(String host, int port) {
        defaultInstance = new WireMock(host, port);
    }

    public static void configureFor(String host, int port, String urlPathPrefix) {
        defaultInstance = new WireMock(host, port, urlPathPrefix);
    }

    public static void configure() {
        defaultInstance = new WireMock();
    }

    public void resetMappings() {
        this.admin.resetMappings();
    }

    public static void reset() {
        defaultInstance.resetMappings();
    }

    public void resetScenarios() {
        this.admin.resetScenarios();
    }

    public static void resetAllScenarios() {
        defaultInstance.resetScenarios();
    }

    public void resetToDefaultMappings() {
        this.admin.resetToDefaultMappings();
    }

    public static void resetToDefault() {
        defaultInstance.resetToDefaultMappings();
    }

    public void register(MappingBuilder mappingBuilder) {
        StubMapping mapping = mappingBuilder.build();
        this.admin.addStubMapping(mapping);
    }

    public static UrlMatchingStrategy urlEqualTo(String url) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrl(url);
        return urlStrategy;
    }

    public static UrlMatchingStrategy urlMatching(String url) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrlPattern(url);
        return urlStrategy;
    }

    public static ValueMatchingStrategy equalTo(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setEqualTo(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy containing(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setContains(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy matching(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setMatches(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy notMatching(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setDoesNotMatch(value);
        return headerStrategy;
    }

    public static MappingBuilder get(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.GET, urlMatchingStrategy);
    }

    public static MappingBuilder post(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.POST, urlMatchingStrategy);
    }

    public static MappingBuilder put(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.PUT, urlMatchingStrategy);
    }

    public static MappingBuilder delete(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.DELETE, urlMatchingStrategy);
    }

    public static MappingBuilder head(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.HEAD, urlMatchingStrategy);
    }

    public static MappingBuilder options(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.OPTIONS, urlMatchingStrategy);
    }

    public static MappingBuilder trace(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.TRACE, urlMatchingStrategy);
    }

    public static MappingBuilder any(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.ANY, urlMatchingStrategy);
    }

    public static ResponseDefinitionBuilder aResponse() {
        return new ResponseDefinitionBuilder();
    }

    public void verifyThat(RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        if (this.admin.countRequestsMatching(requestPattern) < 1) {
            throw new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public void verifyThat(int count, RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        if (this.admin.countRequestsMatching(requestPattern) != count) {
            throw new VerificationException(requestPattern, count, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public static void verify(RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.verifyThat(requestPatternBuilder);
    }

    public static void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.verifyThat(count, requestPatternBuilder);
    }

    public List<LoggedRequest> find(RequestPatternBuilder requestPatternBuilder) {
        FindRequestsResult result = this.admin.findRequestsMatching(requestPatternBuilder.build());
        return result.getRequests();
    }

    public static List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.find(requestPatternBuilder);
    }

    public static RequestPatternBuilder getRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.GET, urlMatchingStrategy);
    }

    public static RequestPatternBuilder postRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.POST, urlMatchingStrategy);
    }

    public static RequestPatternBuilder putRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.PUT, urlMatchingStrategy);
    }

    public static RequestPatternBuilder deleteRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.DELETE, urlMatchingStrategy);
    }

    public static RequestPatternBuilder headRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.HEAD, urlMatchingStrategy);
    }

    public static RequestPatternBuilder optionsRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.OPTIONS, urlMatchingStrategy);
    }

    public static RequestPatternBuilder traceRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.TRACE, urlMatchingStrategy);
    }

    public static void setGlobalFixedDelay(int milliseconds) {
        defaultInstance.setGlobalFixedDelayVariable(milliseconds);
    }

    public void setGlobalFixedDelayVariable(int milliseconds) {
        GlobalSettings settings = new GlobalSettings();
        settings.setFixedDelay(milliseconds);
        this.admin.updateGlobalSettings(settings);
    }

    public void addDelayBeforeProcessingRequests(int milliseconds) {
        this.admin.addSocketAcceptDelay(new RequestDelaySpec(milliseconds));
    }

    public static void addRequestProcessingDelay(int milliseconds) {
        defaultInstance.addDelayBeforeProcessingRequests(milliseconds);
    }
}

