/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    private final StubMappings stubMappings;
    private final InMemoryRequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final RequestDelayControl requestDelayControl;
    private final boolean browserProxyingEnabled;

    public WireMockApp(RequestDelayControl requestDelayControl, boolean browserProxyingEnabled) {
        this.requestDelayControl = requestDelayControl;
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.stubMappings = new InMemoryStubMappings();
        this.requestJournal = new InMemoryRequestJournal();
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.globalSettingsHolder;
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ResponseDefinition serveStubFor(Request request) {
        ResponseDefinition responseDefinition = this.stubMappings.serveFor(request);
        this.requestJournal.requestReceived(request);
        if (!responseDefinition.wasConfigured() && request.isBrowserProxyRequest() && this.browserProxyingEnabled) {
            return ResponseDefinition.browserProxy(request);
        }
        return responseDefinition;
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.stubMappings.addMapping(stubMapping);
    }

    @Override
    public void resetMappings() {
        this.stubMappings.reset();
        this.requestJournal.reset();
        this.requestDelayControl.clearDelay();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return this.requestJournal.countRequestsMatching(requestPattern);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
        return new FindRequestsResult(requests);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.globalSettingsHolder.replaceWith(newSettings);
    }

    @Override
    public void addSocketAcceptDelay(RequestDelaySpec delaySpec) {
        this.requestDelayControl.setDelay(delaySpec.milliseconds());
    }
}

