/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;

public class WireMockServerRunner {
    public static final String FILES_ROOT = "__files";
    public static final String MAPPINGS_ROOT = "mappings";
    private WireMockServer wireMockServer;

    public void run(String fileSourcesRoot, String ... args) {
        CommandLineOptions options = new CommandLineOptions(args);
        if (options.help()) {
            System.out.println(options.helpText());
            return;
        }
        SingleRootFileSource fileSource = new SingleRootFileSource(fileSourcesRoot);
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child(FILES_ROOT);
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child(MAPPINGS_ROOT);
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = options.specifiesPortNumber() ? new WireMockServer(options.portNumber(), fileSource, options.browserProxyingEnabled()) : new WireMockServer(8080, fileSource, options.browserProxyingEnabled());
        if (options.recordMappingsEnabled()) {
            this.wireMockServer.enableRecordMappings(mappingsFileSource, filesFileSource);
        }
        this.wireMockServer.setVerboseLogging(options.verboseLoggingEnabled());
        this.wireMockServer.loadMappingsUsing(new JsonFileMappingsLoader(mappingsFileSource));
        if (options.specifiesProxyUrl()) {
            this.addProxyMapping(options.proxyUrl());
        }
        this.wireMockServer.start();
    }

    private void addProxyMapping(final String baseUrl) {
        this.wireMockServer.loadMappingsUsing(new MappingsLoader(){

            @Override
            public void loadMappingsInto(StubMappings stubMappings) {
                RequestPattern requestPattern = new RequestPattern(RequestMethod.ANY);
                requestPattern.setUrlPattern(".*");
                ResponseDefinition responseDef = new ResponseDefinition();
                responseDef.setProxyBaseUrl(baseUrl);
                stubMappings.addMapping(new StubMapping(requestPattern, responseDef));
            }
        });
    }

    public void stop() {
        this.wireMockServer.stop();
    }

    public static void main(String ... args) {
        new WireMockServerRunner().run(".", args);
    }
}

