/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Log4jNotifier;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.global.ThreadSafeRequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.jetty.DelayableSocketConnector;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.HandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

public class WireMockServer {
    public static final String FILES_ROOT = "__files";
    public static final int DEFAULT_PORT = 8080;
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final WireMockApp wireMockApp;
    private final AdminRequestHandler adminRequestHandler;
    private final StubRequestHandler stubRequestHandler;
    private Server jettyServer;
    private RequestDelayControl requestDelayControl;
    private final FileSource fileSource;
    private final Log4jNotifier notifier = new Log4jNotifier();
    private final int port;

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying) {
        this.fileSource = fileSource;
        this.port = port;
        this.requestDelayControl = new ThreadSafeRequestDelayControl();
        this.wireMockApp = new WireMockApp(this.requestDelayControl, enableBrowserProxying);
        this.adminRequestHandler = new AdminRequestHandler(this.wireMockApp, new BasicResponseRenderer());
        this.stubRequestHandler = new StubRequestHandler(this.wireMockApp, new StubResponseRenderer(fileSource.child(FILES_ROOT), this.wireMockApp.getGlobalSettingsHolder()));
    }

    public WireMockServer(int port) {
        this(port, new SingleRootFileSource("src/test/resources"), false);
    }

    public WireMockServer() {
        this(8080);
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        this.wireMockApp.loadMappingsUsing(mappingsLoader);
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.stubRequestHandler.addRequestListener(listener);
    }

    public void setVerboseLogging(boolean verbose) {
        this.notifier.setVerbose(verbose);
        if (verbose) {
            this.notifier.info("Verbose logging enabled");
        }
    }

    public void enableRecordMappings(FileSource mappingsFileSource, FileSource filesFileSource) {
        this.addMockServiceRequestListener(new StubMappingJsonRecorder(mappingsFileSource, filesFileSource, this.wireMockApp));
        this.notifier.info("Recording mappings to " + mappingsFileSource.getPath());
    }

    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.jettyServer = new Server();
            DelayableSocketConnector connector = new DelayableSocketConnector(this.requestDelayControl);
            connector.setPort(this.port);
            connector.setHeaderBufferSize(8192);
            this.jettyServer.addConnector((Connector)connector);
            this.addAdminContext();
            this.addMockServiceContext();
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.jettyServer != null && this.jettyServer.isRunning();
    }

    private void addMockServiceContext() {
        Context mockServiceContext = new Context((HandlerContainer)this.jettyServer, "/");
        HashMap initParams = Maps.newHashMap();
        initParams.put("org.mortbay.jetty.servlet.Default.maxCacheSize", "0");
        initParams.put("org.mortbay.jetty.servlet.Default.resourceBase", this.fileSource.getPath());
        initParams.put("org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.setInitParams((Map)initParams);
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)this.stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)this.notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, 2);
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, 15);
        this.jettyServer.addHandler((Handler)mockServiceContext);
    }

    private void addAdminContext() {
        Context adminContext = new Context((HandlerContainer)this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)this.adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)this.notifier);
        this.jettyServer.addHandler((Handler)adminContext);
    }
}

