/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public final class Json {
    private Json() {
    }

    public static <T> T read(String json, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to bind JSON to object. Reason: " + ioe.getMessage() + "  JSON:" + json, ioe);
        }
    }

    public static <T> String write(T object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.defaultPrettyPrintingWriter().writeValueAsString(object);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to generate JSON from object. Reason: " + ioe.getMessage(), ioe);
        }
    }
}

